/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import org.agrona.UnsafeApi;
import org.agrona.concurrent.AbstractConcurrentArrayQueue;

public class ManyToManyConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    private static final int SEQUENCES_ARRAY_BASE = UnsafeApi.arrayBaseOffset(long[].class);
    private final long[] sequences;

    public ManyToManyConcurrentArrayQueue(int requestedCapacity) {
        super(requestedCapacity);
        if (requestedCapacity < 2) {
            throw new IllegalArgumentException("requestedCapacity must be >= 2: requestedCapacity=" + requestedCapacity);
        }
        long[] sequences = new long[this.capacity];
        for (int i = 0; i < this.capacity; ++i) {
            sequences[i] = i;
        }
        UnsafeApi.putLongVolatile(sequences, ManyToManyConcurrentArrayQueue.sequenceArrayOffset(0L, sequences.length - 1), 0L);
        this.sequences = sequences;
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("element cannot be null");
        }
        long mask = this.capacity - 1;
        long[] sequences = this.sequences;
        Object[] buffer = this.buffer;
        long currentTail;
        long sequenceOffset;
        long sequence;
        while ((sequence = UnsafeApi.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentTail = this.tail, mask))) >= currentTail) {
            if (UnsafeApi.compareAndSetLong(this, TAIL_OFFSET, currentTail, currentTail + 1L)) {
                UnsafeApi.putReference(buffer, ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentTail, mask), e);
                UnsafeApi.putLongRelease(sequences, sequenceOffset, currentTail + 1L);
                return true;
            }
            Thread.onSpinWait();
        }
        return false;
    }

    @Override
    public E poll() {
        long[] sequences = this.sequences;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long attemptedHead;
        long currentHead;
        long sequenceOffset;
        long sequence;
        while ((sequence = UnsafeApi.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentHead = this.head, mask))) >= (attemptedHead = currentHead + 1L)) {
            if (UnsafeApi.compareAndSetLong(this, HEAD_OFFSET, currentHead, attemptedHead)) {
                long elementOffset = ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentHead, mask);
                Object e = UnsafeApi.getReference(buffer, elementOffset);
                UnsafeApi.putReference(buffer, elementOffset, null);
                UnsafeApi.putLongRelease(sequences, sequenceOffset, attemptedHead + mask);
                return (E)e;
            }
            Thread.onSpinWait();
        }
        return null;
    }

    @Override
    public E peek() {
        long[] sequences = this.sequences;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long attemptedHead;
        long currentHead;
        long sequenceOffset;
        long sequence;
        while ((sequence = UnsafeApi.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentHead = this.head, mask))) >= (attemptedHead = currentHead + 1L)) {
            if (sequence == attemptedHead) {
                long elementOffset = ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentHead, mask);
                Object e = UnsafeApi.getReference(buffer, elementOffset);
                if (currentHead == this.head) {
                    return (E)e;
                }
            }
            Thread.onSpinWait();
        }
        return null;
    }

    @Override
    public int drain(Consumer<E> elementConsumer) {
        return this.drain(elementConsumer, this.size());
    }

    @Override
    public int drain(Consumer<E> elementConsumer, int limit) {
        E e;
        int count;
        for (count = 0; count < limit && null != (e = this.poll()); ++count) {
            elementConsumer.accept(e);
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> target, int limit) {
        E e;
        int count;
        for (count = 0; count < limit && null != (e = this.poll()); ++count) {
            target.add(e);
        }
        return count;
    }

    private static long sequenceArrayOffset(long sequence, long mask) {
        return (long)SEQUENCES_ARRAY_BASE + ((sequence & mask) << 3);
    }
}

