/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.agent;

import net.bytebuddy.asm.Advice;
import org.agrona.DirectBuffer;
import org.agrona.agent.BufferAlignmentException;

public class BufferAlignmentInterceptor {

    public static final class CharVerifier
    extends Verifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            CharVerifier.verifyAlignment(index, buffer, 2);
        }
    }

    public static final class ShortVerifier
    extends Verifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            ShortVerifier.verifyAlignment(index, buffer, 2);
        }
    }

    public static final class FloatVerifier
    extends Verifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            FloatVerifier.verifyAlignment(index, buffer, 4);
        }
    }

    public static final class IntVerifier
    extends Verifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            IntVerifier.verifyAlignment(index, buffer, 4);
        }
    }

    public static final class DoubleVerifier
    extends Verifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            DoubleVerifier.verifyAlignment(index, buffer, 8);
        }
    }

    public static final class LongVerifier
    extends Verifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            LongVerifier.verifyAlignment(index, buffer, 8);
        }
    }

    static abstract class Verifier {
        Verifier() {
        }

        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer, int alignment) {
            if ((buffer.addressOffset() + (long)index) % (long)alignment != 0L) {
                String message = String.format("Unaligned %d-byte access (Index=%d, Buffer Alignment Offset=%d)", alignment, index, (int)(buffer.addressOffset() % (long)alignment));
                throw new BufferAlignmentException(message);
            }
        }
    }
}

