/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aeonbits.owner.Accessible;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigURLFactory;
import org.aeonbits.owner.HotReloadLogic;
import org.aeonbits.owner.LoadersManager;
import org.aeonbits.owner.Mutable;
import org.aeonbits.owner.PropertiesInvocationHandler;
import org.aeonbits.owner.PropertiesMapper;
import org.aeonbits.owner.Reloadable;
import org.aeonbits.owner.Util;
import org.aeonbits.owner.VariablesExpander;
import org.aeonbits.owner.event.ReloadEvent;
import org.aeonbits.owner.event.ReloadListener;
import org.aeonbits.owner.event.RollbackBatchException;
import org.aeonbits.owner.event.RollbackException;
import org.aeonbits.owner.event.RollbackOperationException;
import org.aeonbits.owner.event.TransactionalPropertyChangeListener;
import org.aeonbits.owner.event.TransactionalReloadListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesManager
implements Reloadable,
Accessible,
Mutable {
    private final Class<? extends Config> clazz;
    private final Map<?, ?>[] imports;
    private final Properties properties;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Config.LoadType loadType;
    private final List<URL> urls;
    private final HotReloadLogic hotReloadLogic;
    private volatile boolean loading = false;
    final List<ReloadListener> reloadListeners = Collections.synchronizedList(new LinkedList());
    private Object proxy;
    private final LoadersManager loaders;
    final List<PropertyChangeListener> propertyChangeListeners = Collections.synchronizedList(new LinkedList<PropertyChangeListener>(){

        @Override
        public boolean remove(Object o) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (!item.equals(o)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
    });

    PropertiesManager(Class<? extends Config> clazz, Properties properties, ScheduledExecutorService scheduler, VariablesExpander expander, LoadersManager loaders, Map<?, ?> ... imports) {
        this.clazz = clazz;
        this.properties = properties;
        this.loaders = loaders;
        this.imports = imports;
        ConfigURLFactory urlFactory = new ConfigURLFactory(clazz.getClassLoader(), expander);
        this.urls = this.toURLs(clazz.getAnnotation(Config.Sources.class), urlFactory);
        Config.LoadPolicy loadPolicy = clazz.getAnnotation(Config.LoadPolicy.class);
        this.loadType = loadPolicy != null ? loadPolicy.value() : Config.LoadType.FIRST;
        Config.HotReload hotReload = clazz.getAnnotation(Config.HotReload.class);
        if (hotReload != null) {
            this.hotReloadLogic = new HotReloadLogic(hotReload, this.urls, this);
            if (this.hotReloadLogic.isAsync()) {
                scheduler.scheduleAtFixedRate(new Runnable(){

                    public void run() {
                        PropertiesManager.this.hotReloadLogic.checkAndReload();
                    }
                }, hotReload.value(), hotReload.value(), hotReload.unit());
            }
        } else {
            this.hotReloadLogic = null;
        }
    }

    private List<URL> toURLs(Config.Sources sources, ConfigURLFactory urlFactory) {
        String[] specs = this.specs(sources, urlFactory);
        ArrayList<URL> result = new ArrayList<URL>();
        for (String spec : specs) {
            try {
                URL url = urlFactory.newURL(spec);
                if (url == null) continue;
                result.add(url);
            }
            catch (MalformedURLException e) {
                throw Util.unsupported(e, "Can't convert '%s' to a valid URL", spec);
            }
        }
        return result;
    }

    private String[] specs(Config.Sources sources, ConfigURLFactory urlFactory) {
        if (sources != null) {
            return sources.value();
        }
        return this.defaultSpecs(urlFactory);
    }

    private String[] defaultSpecs(ConfigURLFactory urlFactory) {
        String prefix = urlFactory.toClasspathURLSpec(this.clazz.getName());
        return this.loaders.defaultSpecs(prefix);
    }

    Properties load() {
        this.writeLock.lock();
        try {
            Properties properties = this.load(this.properties);
            return properties;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(Properties props) {
        try {
            this.loading = true;
            PropertiesMapper.defaults(props, this.clazz);
            Properties loadedFromFile = this.doLoad();
            PropertiesManager.merge(props, loadedFromFile);
            PropertiesManager.merge(props, Util.reverse(this.imports));
            Properties properties = props;
            return properties;
        }
        finally {
            this.loading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Delegate
    public void reload() {
        this.writeLock.lock();
        try {
            Properties loaded = this.load(new Properties());
            List<PropertyChangeEvent> events = this.fireBeforePropertyChangeEvents(this.keys(this.properties, loaded), this.properties, loaded);
            ReloadEvent reloadEvent = this.fireBeforeReloadEvent(events, this.properties, loaded);
            this.applyPropertyChangeEvents(events);
            this.firePropertyChangeEvents(events);
            this.fireReloadEvent(reloadEvent);
        }
        catch (RollbackBatchException e) {
            Util.ignore();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<?> keys(Map<?, ?> ... maps) {
        HashSet keys = new HashSet();
        for (Map<?, ?> map : maps) {
            keys.addAll(map.keySet());
        }
        return keys;
    }

    private void applyPropertyChangeEvents(List<PropertyChangeEvent> events) {
        for (PropertyChangeEvent event : events) {
            this.performSetProperty(event.getPropertyName(), event.getNewValue());
        }
    }

    private void fireReloadEvent(ReloadEvent reloadEvent) {
        for (ReloadListener listener : this.reloadListeners) {
            listener.reloadPerformed(reloadEvent);
        }
    }

    private ReloadEvent fireBeforeReloadEvent(List<PropertyChangeEvent> events, Properties oldProperties, Properties newProperties) throws RollbackBatchException {
        ReloadEvent reloadEvent = new ReloadEvent(this.proxy, events, oldProperties, newProperties);
        for (ReloadListener listener : this.reloadListeners) {
            if (!(listener instanceof TransactionalReloadListener)) continue;
            ((TransactionalReloadListener)listener).beforeReload(reloadEvent);
        }
        return reloadEvent;
    }

    @Override
    @Delegate
    public void addReloadListener(ReloadListener listener) {
        if (listener != null) {
            this.reloadListeners.add(listener);
        }
    }

    @Override
    @Delegate
    public void removeReloadListener(ReloadListener listener) {
        if (listener != null) {
            this.reloadListeners.remove(listener);
        }
    }

    @Override
    @Delegate
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.add(listener);
        }
    }

    @Override
    @Delegate
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    @Override
    @Delegate
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == null || listener == null) {
            return;
        }
        boolean transactional = listener instanceof TransactionalPropertyChangeListener;
        this.propertyChangeListeners.add(new PropertyChangeListenerWrapper(propertyName, listener, transactional));
    }

    Properties doLoad() {
        return this.loadType.load(this.urls, this.loaders);
    }

    private static void merge(Properties results, Map<?, ?> ... inputs) {
        for (Map<?, ?> input : inputs) {
            results.putAll(input);
        }
    }

    @Override
    @Delegate
    public String getProperty(String key) {
        this.readLock.lock();
        try {
            String string = this.properties.getProperty(key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void syncReloadCheck() {
        if (this.hotReloadLogic != null && this.hotReloadLogic.isSync()) {
            this.hotReloadLogic.checkAndReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Delegate
    public String getProperty(String key, String defaultValue) {
        this.readLock.lock();
        try {
            String string = this.properties.getProperty(key, defaultValue);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @Delegate
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.readLock.lock();
        try {
            this.properties.storeToXML(os, comment);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @Delegate
    public Set<String> propertyNames() {
        this.readLock.lock();
        try {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            Enumeration<?> propertyNames = this.properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                result.add((String)propertyNames.nextElement());
            }
            LinkedHashSet<String> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @Delegate
    public void list(PrintStream out) {
        this.readLock.lock();
        try {
            this.properties.list(out);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @Delegate
    public void list(PrintWriter out) {
        this.readLock.lock();
        try {
            this.properties.list(out);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @Delegate
    public void store(OutputStream out, String comments) throws IOException {
        this.readLock.lock();
        try {
            this.properties.store(out, comments);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Delegate
    public String setProperty(String key, String newValue) {
        this.writeLock.lock();
        try {
            PropertyChangeEvent event;
            String oldValue = this.properties.getProperty(key);
            try {
                if (Util.eq(oldValue, newValue)) {
                    String string = oldValue;
                    return string;
                }
                event = new PropertyChangeEvent(this.proxy, key, oldValue, newValue);
            }
            catch (RollbackException e) {
                String string = oldValue;
                return string;
            }
            this.fireBeforePropertyChange(event);
            String result = this.performSetProperty(key, newValue);
            this.firePropertyChange(event);
            String string = result;
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String performSetProperty(String key, Object value) {
        return value == null ? this.performRemoveProperty(key) : Util.asString(this.properties.setProperty(key, Util.asString(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Delegate
    public String removeProperty(String key) {
        this.writeLock.lock();
        try {
            String oldValue = this.properties.getProperty(key);
            Object newValue = null;
            PropertyChangeEvent event = new PropertyChangeEvent(this.proxy, key, oldValue, newValue);
            this.fireBeforePropertyChange(event);
            String result = this.performRemoveProperty(key);
            this.firePropertyChange(event);
            String string = result;
            return string;
        }
        catch (RollbackException e) {
            String string = this.properties.getProperty(key);
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String performRemoveProperty(String key) {
        return Util.asString(this.properties.remove(key));
    }

    @Override
    @Delegate
    public void clear() {
        this.writeLock.lock();
        try {
            List<PropertyChangeEvent> events = this.fireBeforePropertyChangeEvents(this.keys(this.properties), this.properties, new Properties());
            this.applyPropertyChangeEvents(events);
            this.firePropertyChangeEvents(events);
        }
        catch (RollbackBatchException e) {
            Util.ignore();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @Delegate
    public void load(InputStream inStream) throws IOException {
        this.writeLock.lock();
        try {
            Properties loaded = new Properties();
            loaded.load(inStream);
            this.performLoad(this.keys(loaded), loaded);
        }
        catch (RollbackBatchException ex) {
            Util.ignore();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void performLoad(Set keys, Properties props) throws RollbackBatchException {
        List<PropertyChangeEvent> events = this.fireBeforePropertyChangeEvents(keys, this.properties, props);
        this.applyPropertyChangeEvents(events);
        this.firePropertyChangeEvents(events);
    }

    @Override
    @Delegate
    public void load(Reader reader) throws IOException {
        this.writeLock.lock();
        try {
            Properties loaded = new Properties();
            loaded.load(reader);
            this.performLoad(this.keys(loaded), loaded);
        }
        catch (RollbackBatchException ex) {
            Util.ignore();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    @Delegate
    public String toString() {
        this.readLock.lock();
        try {
            String string = this.properties.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    boolean isLoading() {
        return this.loading;
    }

    private List<PropertyChangeEvent> fireBeforePropertyChangeEvents(Set keys, Properties oldValues, Properties newValues) throws RollbackBatchException {
        ArrayList<PropertyChangeEvent> events = new ArrayList<PropertyChangeEvent>();
        for (Object keyObject : keys) {
            String newValue;
            String key = (String)keyObject;
            String oldValue = oldValues.getProperty(key);
            if (Util.eq(oldValue, newValue = newValues.getProperty(key))) continue;
            PropertyChangeEvent event = new PropertyChangeEvent(this.proxy, key, oldValue, newValue);
            try {
                this.fireBeforePropertyChange(event);
                events.add(event);
            }
            catch (RollbackOperationException e) {
                Util.ignore();
            }
        }
        return events;
    }

    private void firePropertyChangeEvents(List<PropertyChangeEvent> events) {
        for (PropertyChangeEvent event : events) {
            this.firePropertyChange(event);
        }
    }

    private void fireBeforePropertyChange(PropertyChangeEvent event) throws RollbackBatchException, RollbackOperationException {
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            if (!(listener instanceof TransactionalPropertyChangeListener)) continue;
            ((TransactionalPropertyChangeListener)listener).beforePropertyChange(event);
        }
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    @Delegate
    public boolean equals(Object obj) {
        if (!(obj instanceof Proxy)) {
            return false;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(obj);
        if (!(handler instanceof PropertiesInvocationHandler)) {
            return false;
        }
        PropertiesInvocationHandler propsInvocationHandler = (PropertiesInvocationHandler)handler;
        PropertiesManager that = propsInvocationHandler.propertiesManager;
        return this.equals(that);
    }

    private boolean equals(PropertiesManager that) {
        if (!this.isAssignationCompatibleWith(that)) {
            return false;
        }
        this.readLock.lock();
        try {
            that.readLock.lock();
            try {
                boolean bl = this.properties.equals(that.properties);
                that.readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                that.readLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isAssignationCompatibleWith(PropertiesManager that) {
        return this.clazz.isAssignableFrom(that.clazz) || that.clazz.isAssignableFrom(this.clazz);
    }

    @Delegate
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.properties.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class PropertyChangeListenerWrapper
    implements TransactionalPropertyChangeListener,
    Serializable {
        private final String propertyName;
        private final PropertyChangeListener listener;
        private final boolean transactional;

        public PropertyChangeListenerWrapper(String propertyName, PropertyChangeListener listener, boolean transactional) {
            this.propertyName = propertyName;
            this.listener = listener;
            this.transactional = transactional;
        }

        public void beforePropertyChange(PropertyChangeEvent event) throws RollbackOperationException, RollbackBatchException {
            if (this.transactional && this.propertyNameMatches(event)) {
                ((TransactionalPropertyChangeListener)this.listener).beforePropertyChange(event);
            }
        }

        private boolean propertyNameMatches(PropertyChangeEvent event) {
            return this.propertyName.equals(event.getPropertyName());
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.propertyNameMatches(event)) {
                this.listener.propertyChange(event);
            }
        }

        public boolean equals(Object obj) {
            return this.listener.equals(obj);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface Delegate {
    }
}

