/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Converters;
import org.aeonbits.owner.PropertiesManager;
import org.aeonbits.owner.PropertiesMapper;
import org.aeonbits.owner.StrSubstitutor;
import org.aeonbits.owner.Util;
import org.aeonbits.owner.util.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesInvocationHandler
implements InvocationHandler,
Serializable {
    private static final Method[] DELEGATES = PropertiesInvocationHandler.findDelegates();
    private final StrSubstitutor substitutor;
    final PropertiesManager propertiesManager;

    PropertiesInvocationHandler(PropertiesManager manager) {
        this.propertiesManager = manager;
        this.substitutor = new StrSubstitutor(manager.load());
    }

    @Override
    public Object invoke(Object proxy, Method invokedMethod, Object ... args) throws Throwable {
        this.propertiesManager.syncReloadCheck();
        if (Reflection.isDefault(invokedMethod)) {
            return Reflection.invokeDefaultMethod(proxy, invokedMethod, args);
        }
        Method delegate = this.getDelegateMethod(invokedMethod);
        if (delegate != null) {
            return this.delegate(delegate, args);
        }
        return this.resolveProperty(invokedMethod, args);
    }

    private Object delegate(Method delegate, Object[] args) throws Throwable {
        try {
            return delegate.invoke((Object)this.propertiesManager, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Method getDelegateMethod(Method invokedMethod) {
        for (Method delegate : DELEGATES) {
            if (!this.equals(invokedMethod, delegate)) continue;
            return delegate;
        }
        return null;
    }

    private boolean equals(Method a, Method b) {
        return a.getName().equals(b.getName()) && a.getReturnType().equals(b.getReturnType()) && Arrays.equals(a.getParameterTypes(), b.getParameterTypes());
    }

    private Object resolveProperty(Method method, Object ... args) {
        String key = this.expandKey(method);
        String value = this.propertiesManager.getProperty(key);
        if (value == null && !Util.isFeatureDisabled(method, Config.DisableableFeature.VARIABLE_EXPANSION)) {
            String unexpandedKey = PropertiesMapper.key(method);
            value = this.propertiesManager.getProperty(unexpandedKey);
        }
        if (value == null) {
            return null;
        }
        Object result = Converters.convert(method, method.getReturnType(), this.format(method, this.expandVariables(method, value), args));
        if (result == Converters.NULL) {
            return null;
        }
        return result;
    }

    private String expandKey(Method method) {
        String key = PropertiesMapper.key(method);
        if (Util.isFeatureDisabled(method, Config.DisableableFeature.VARIABLE_EXPANSION)) {
            return key;
        }
        return this.substitutor.replace(key);
    }

    private String format(Method method, String format, Object ... args) {
        if (Util.isFeatureDisabled(method, Config.DisableableFeature.PARAMETER_FORMATTING)) {
            return format;
        }
        return String.format(format, args);
    }

    private String expandVariables(Method method, String value) {
        if (Util.isFeatureDisabled(method, Config.DisableableFeature.VARIABLE_EXPANSION)) {
            return value;
        }
        return this.substitutor.replace(value);
    }

    private static Method[] findDelegates() {
        Method[] methods;
        LinkedList<Method> result = new LinkedList<Method>();
        for (Method m : methods = PropertiesManager.class.getMethods()) {
            if (m.getAnnotation(PropertiesManager.Delegate.class) == null) continue;
            result.add(m);
        }
        return result.toArray(new Method[result.size()]);
    }

    public <T extends Config> void setProxy(T proxy) {
        this.propertiesManager.setProxy(proxy);
    }
}

