/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Factory;
import org.aeonbits.owner.LoadersManager;
import org.aeonbits.owner.PropertiesInvocationHandler;
import org.aeonbits.owner.PropertiesManager;
import org.aeonbits.owner.VariablesExpander;
import org.aeonbits.owner.loaders.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFactory
implements Factory {
    private final ScheduledExecutorService scheduler;
    private Properties props;
    final LoadersManager loadersManager;

    DefaultFactory(ScheduledExecutorService scheduler, Properties props) {
        this.scheduler = scheduler;
        this.props = props;
        this.loadersManager = new LoadersManager();
    }

    @Override
    public <T extends Config> T create(Class<? extends T> clazz, Map<?, ?> ... imports) {
        Class[] interfaces = new Class[]{clazz};
        VariablesExpander expander = new VariablesExpander(this.props);
        PropertiesManager manager = new PropertiesManager(clazz, new Properties(), this.scheduler, expander, this.loadersManager, imports);
        PropertiesInvocationHandler handler = new PropertiesInvocationHandler(manager);
        Config proxy = (Config)Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)handler);
        handler.setProxy(proxy);
        return (T)proxy;
    }

    @Override
    public String setProperty(String key, String value) {
        this.checkKey(key);
        return (String)this.props.setProperty(key, value);
    }

    private void checkKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public void setProperties(Properties properties) {
        this.props = properties == null ? new Properties() : properties;
    }

    @Override
    public void registerLoader(Loader loader) {
        this.loadersManager.registerLoader(loader);
    }

    @Override
    public String getProperty(String key) {
        this.checkKey(key);
        return this.props.getProperty(key);
    }

    @Override
    public String clearProperty(String key) {
        this.checkKey(key);
        return (String)this.props.remove(key);
    }
}

