/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Converter;
import org.aeonbits.owner.Tokenizer;
import org.aeonbits.owner.TokenizerResolver;
import org.aeonbits.owner.Util;
import org.aeonbits.owner.util.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Converters {
    ARRAY{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            if (!targetType.isArray()) {
                return SKIP;
            }
            Class<?> type = targetType.getComponentType();
            if (text.trim().isEmpty()) {
                return Array.newInstance(type, 0);
            }
            Tokenizer tokenizer = TokenizerResolver.resolveTokenizer(targetMethod);
            String[] chunks = tokenizer.tokens(text);
            Converters converter = Converters.doConvert(targetMethod, type, chunks[0]).getConverter();
            Object result = Array.newInstance(type, chunks.length);
            for (int i = 0; i < chunks.length; ++i) {
                String chunk = chunks[i];
                Object value = converter.tryConvert(targetMethod, type, chunk);
                Array.set(result, i, value);
            }
            return result;
        }
    }
    ,
    COLLECTION{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            if (!Collection.class.isAssignableFrom(targetType)) {
                return SKIP;
            }
            Object[] array = this.convertToArray(targetMethod, text);
            List<Object> collection = Arrays.asList(array);
            Collection<?> result = this.instantiateCollection(targetType);
            result.addAll(collection);
            return result;
        }

        private Object[] convertToArray(Method targetMethod, String text) {
            Class<?> type = this.getGenericType(targetMethod);
            Object stub = Array.newInstance(type, 0);
            return (Object[])ARRAY.tryConvert(targetMethod, stub.getClass(), text);
        }

        private Class<?> getGenericType(Method targetMethod) {
            if (targetMethod.getGenericReturnType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)targetMethod.getGenericReturnType();
                return (Class)parameterizedType.getActualTypeArguments()[0];
            }
            return String.class;
        }

        private <T> Collection<T> instantiateCollection(Class<? extends T> targetType) {
            if (targetType.isInterface()) {
                return this.instantiateCollectionFromInterface(targetType);
            }
            return this.instantiateCollectionFromClass(targetType);
        }

        private <T> Collection<T> instantiateCollectionFromClass(Class<? extends T> targetType) {
            try {
                return (Collection)targetType.newInstance();
            }
            catch (Exception e) {
                throw Util.unsupported(e, "Cannot instantiate collection of type '%s'", targetType.getCanonicalName());
            }
        }

        private <T> Collection<T> instantiateCollectionFromInterface(Class<? extends T> targetType) {
            if (List.class.isAssignableFrom(targetType)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(targetType)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(targetType)) {
                return new LinkedHashSet();
            }
            return new ArrayList();
        }
    }
    ,
    METHOD_WITH_CONVERTER_CLASS_ANNOTATION{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            Converter converter;
            Config.ConverterClass annotation = targetMethod.getAnnotation(Config.ConverterClass.class);
            if (annotation == null) {
                return SKIP;
            }
            Class<? extends Converter> converterClass = annotation.value();
            try {
                converter = converterClass.newInstance();
            }
            catch (InstantiationException e) {
                throw Util.unsupported(e, "Converter class %s can't be instantiated: %s", converterClass.getCanonicalName(), e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw Util.unsupported(e, "Converter class %s can't be accessed: %s", converterClass.getCanonicalName(), e.getMessage());
            }
            Object result = converter.convert(targetMethod, text);
            if (result == null) {
                return NULL;
            }
            return result;
        }
    }
    ,
    PROPERTY_EDITOR{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            if (!this.canUsePropertyEditors()) {
                return SKIP;
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
            if (editor == null) {
                return SKIP;
            }
            try {
                editor.setAsText(text);
                return editor.getValue();
            }
            catch (Exception e) {
                throw Converters.unsupportedConversion(targetType, text);
            }
        }

        private boolean canUsePropertyEditors() {
            return this.isPropertyEditoryAvailable() && !this.isPropertyEditorDisabled();
        }

        private boolean isPropertyEditoryAvailable() {
            return Reflection.isClassAvailable("java.beans.PropertyEditorManager");
        }

        private boolean isPropertyEditorDisabled() {
            return Boolean.getBoolean("org.aeonbits.owner.property.editor.disabled");
        }
    }
    ,
    PRIMITIVE{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            if (!targetType.isPrimitive()) {
                return SKIP;
            }
            if (targetType == Byte.TYPE) {
                return Byte.parseByte(text);
            }
            if (targetType == Short.TYPE) {
                return Short.parseShort(text);
            }
            if (targetType == Integer.TYPE) {
                return Integer.parseInt(text);
            }
            if (targetType == Long.TYPE) {
                return Long.parseLong(text);
            }
            if (targetType == Boolean.TYPE) {
                return Boolean.parseBoolean(text);
            }
            if (targetType == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(text));
            }
            if (targetType == Double.TYPE) {
                return Double.parseDouble(text);
            }
            return SKIP;
        }
    }
    ,
    FILE{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            if (targetType != File.class) {
                return SKIP;
            }
            return new File(Util.expandUserHome(text));
        }
    }
    ,
    CLASS{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            if (targetType != Class.class) {
                return SKIP;
            }
            try {
                return Class.forName(text);
            }
            catch (ClassNotFoundException ex) {
                throw Util.unsupported(ex, "Cannot convert '%s' to %s", text, targetType.getCanonicalName());
            }
        }
    }
    ,
    CLASS_WITH_STRING_CONSTRUCTOR{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            try {
                Constructor<?> constructor = targetType.getConstructor(String.class);
                return constructor.newInstance(text);
            }
            catch (Exception e) {
                return SKIP;
            }
        }
    }
    ,
    CLASS_WITH_VALUE_OF_METHOD{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            try {
                Method method = targetType.getMethod("valueOf", String.class);
                if (Modifier.isStatic(method.getModifiers())) {
                    return method.invoke(null, text);
                }
                return SKIP;
            }
            catch (Exception e) {
                return SKIP;
            }
        }
    }
    ,
    CLASS_WITH_OBJECT_CONSTRUCTOR{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            try {
                Constructor<?> constructor = targetType.getConstructor(Object.class);
                return constructor.newInstance(text);
            }
            catch (Exception e) {
                return SKIP;
            }
        }
    }
    ,
    UNSUPPORTED{

        @Override
        Object tryConvert(Method targetMethod, Class<?> targetType, String text) {
            throw Converters.unsupportedConversion(targetType, text);
        }
    };

    static final Object NULL;
    static final Object SKIP;

    abstract Object tryConvert(Method var1, Class<?> var2, String var3);

    static Object convert(Method targetMethod, Class<?> targetType, String text) {
        return Converters.doConvert(targetMethod, targetType, text).getConvertedValue();
    }

    private static ConversionResult doConvert(Method targetMethod, Class<?> targetType, String text) {
        for (Converters converter : Converters.values()) {
            Object convertedValue = converter.tryConvert(targetMethod, targetType, text);
            if (convertedValue == SKIP) continue;
            return new ConversionResult(converter, convertedValue);
        }
        return (ConversionResult)Util.unreachableButCompilerNeedsThis();
    }

    private static UnsupportedOperationException unsupportedConversion(Class<?> targetType, String text) {
        return Util.unsupported("Cannot convert '%s' to %s", text, targetType.getCanonicalName());
    }

    static {
        NULL = new Object();
        SKIP = new Object();
    }

    private static class ConversionResult {
        private final Converters converter;
        private final Object convertedValue;

        public ConversionResult(Converters converter, Object convertedValue) {
            this.converter = converter;
            this.convertedValue = convertedValue;
        }

        public Converters getConverter() {
            return this.converter;
        }

        public Object getConvertedValue() {
            return this.convertedValue;
        }
    }
}

