/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.util.bytesize;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.aeonbits.owner.util.bytesize.ByteSizeUnit;

public class ByteSize {
    private final BigDecimal value;
    private final ByteSizeUnit unit;

    public ByteSize(BigDecimal value, ByteSizeUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public ByteSize(long bytes) {
        this(bytes, ByteSizeUnit.BYTES);
    }

    public ByteSize(String value, ByteSizeUnit unit) {
        this(new BigDecimal(value), unit);
    }

    public ByteSize(long value, ByteSizeUnit unit) {
        this(BigDecimal.valueOf(value), unit);
    }

    public ByteSize(double value, ByteSizeUnit unit) {
        this(BigDecimal.valueOf(value), unit);
    }

    public BigInteger getBytes() {
        return this.value.multiply(this.unit.getFactor()).setScale(0, RoundingMode.CEILING).toBigIntegerExact();
    }

    public long getBytesAsLong() {
        return this.getBytes().longValueExact();
    }

    public int getBytesAsInt() {
        return this.getBytes().intValueExact();
    }

    public ByteSize convertTo(ByteSizeUnit unit) {
        BigDecimal bytes = this.value.multiply(this.unit.getFactor()).setScale(0, RoundingMode.CEILING);
        return new ByteSize(bytes.divide(unit.getFactor()), unit);
    }

    public String toString() {
        return this.value.toString() + " " + this.unit.toStringShortForm();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteSize byteSize = (ByteSize)o;
        return this.getBytes().equals(byteSize.getBytes());
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.unit.hashCode();
        return result;
    }
}

