/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.converters;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.aeonbits.owner.Converter;
import org.aeonbits.owner.converters.ConverterUtil;
import org.aeonbits.owner.util.bytesize.ByteSize;
import org.aeonbits.owner.util.bytesize.ByteSizeUnit;

public class ByteSizeConverter
implements Converter<ByteSize> {
    public ByteSize convert(Method method, String input) {
        return ByteSizeConverter.parse(input);
    }

    private static ByteSize parse(String input) {
        String[] parts = ConverterUtil.splitNumericAndChar(input);
        String value = parts[0];
        String unit = parts[1];
        BigDecimal bdValue = new BigDecimal(value);
        ByteSizeUnit bsuUnit = ByteSizeUnit.parse(unit);
        if (bsuUnit == null) {
            throw new IllegalArgumentException("Invalid unit string: '" + unit + "'");
        }
        return new ByteSize(bdValue, bsuUnit);
    }
}

