/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.zookeeper;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.utils.ZKPaths;
import sun.net.www.protocol.zookeeper.NoRetryPolicy;

public class ZooKeeperConnection
extends URLConnection {
    private final String basePath;
    private final CuratorFramework client;

    protected ZooKeeperConnection(URL url) throws MalformedURLException {
        super(url);
        String host = url.getHost();
        int port = url.getPort();
        this.basePath = url.getPath();
        String connectString = port == -1 ? host : host + ":" + port;
        this.client = CuratorFrameworkFactory.newClient((String)connectString, (RetryPolicy)new NoRetryPolicy());
    }

    public void connect() throws IOException {
        this.client.start();
        try {
            int timeout = this.getZookeeperTimeout();
            this.client.blockUntilConnected(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return new ZooKeeperStream(this.client, this.basePath);
    }

    public int getZookeeperTimeout() {
        return Integer.parseInt(System.getProperty("owner.zookeeper.connection.timeout.seconds", "30"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZooKeeperStream
    extends InputStream {
        private final CuratorFramework client;
        private final String basePath;

        public ZooKeeperStream(CuratorFramework client, String basePath) {
            this.client = client;
            this.basePath = basePath;
        }

        public Map<String, String> pairs() throws IOException {
            HashMap<String, String> pairsMap = new HashMap<String, String>();
            try {
                for (String key : (List)this.client.getChildren().forPath(this.basePath)) {
                    pairsMap.put(key, new String((byte[])this.client.getData().forPath(ZKPaths.makePath((String)this.basePath, (String)key))));
                }
                return pairsMap;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            this.client.close();
        }

        @Override
        public int read() throws IOException {
            throw new IOException("not supported operation");
        }

        @Override
        public int read(byte[] b) throws IOException {
            throw new IOException("not supported operation");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            throw new IOException("not supported operation");
        }

        @Override
        public long skip(long n) throws IOException {
            throw new IOException("not supported operation");
        }

        @Override
        public int available() throws IOException {
            throw new IOException("not supported operation");
        }
    }
}

