/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.loaders;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.loaders.Loader;
import org.apache.curator.RetryPolicy;
import org.apache.curator.RetrySleeper;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.utils.ZKPaths;

public class ZooKeeperLoader
implements Loader {
    private static final String SCHEME = "zookeeper";
    private static final String ZOOKEEPER_CONNECTION_TIMEOUT_SECONDS = "owner.zookeeper.connection.timeout.seconds";

    public boolean accept(URI uri) {
        return uri.getScheme().equals(SCHEME);
    }

    public void load(Properties result, URI uri) throws IOException {
        CuratorFramework client = this.getClient(uri);
        try {
            this.connect(client);
            String basePath = uri.getPath();
            for (String key : (List)client.getChildren().forPath(basePath)) {
                result.put(key, this.getValue(client, basePath, key));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            client.close();
        }
    }

    private String getValue(CuratorFramework client, String basePath, String key) throws Exception {
        return new String((byte[])client.getData().forPath(ZKPaths.makePath((String)basePath, (String)key)));
    }

    private void connect(CuratorFramework client) throws InterruptedException {
        client.start();
        int timeout = Integer.parseInt(System.getProperty(ZOOKEEPER_CONNECTION_TIMEOUT_SECONDS, "30"));
        client.blockUntilConnected(timeout, TimeUnit.SECONDS);
    }

    private CuratorFramework getClient(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        String connectString = port == -1 ? host : host + ":" + port;
        return CuratorFrameworkFactory.newClient((String)connectString, (RetryPolicy)new RetryPolicy(){

            public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
                return false;
            }
        });
    }

    public String defaultSpecFor(String urlPrefix) {
        return null;
    }
}

