/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.examples;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;
import org.aeonbits.owner.Reloadable;
import org.aeonbits.owner.event.ReloadEvent;
import org.aeonbits.owner.event.ReloadListener;
import org.aeonbits.owner.util.Util;

public class HotReloadExample {
    private static final String CFG_FILE = "file:target/examples-generated-resources/HotReloadExample.properties";
    private static File target;

    public static void main(String[] args) throws IOException, InterruptedException {
        System.out.printf("\n\n HOT RELOAD EXAMPLE \n\n", new Object[0]);
        Util.save((File)target, (Properties)new Properties(){
            {
                this.setProperty("someValue", "10");
            }
        });
        AutoReloadConfig cfg = (AutoReloadConfig)ConfigFactory.create(AutoReloadConfig.class, (Map[])new Map[0]);
        cfg.addReloadListener(new ReloadListener(){

            public void reloadPerformed(ReloadEvent event) {
                System.out.print("\rReload intercepted at " + new Date() + " \n");
            }
        });
        System.out.println("The program is running. ");
        System.out.println("Now you can change the file located at: \n\n\t" + target.getAbsolutePath() + "\n\n ...and see the changes reflected below\n\n");
        int someValue = 0;
        while (someValue >= 0) {
            someValue = cfg.someValue();
            System.out.print("\rsomeValue is: " + someValue + "\t\t\t\t");
            Thread.sleep(500L);
        }
    }

    static {
        try {
            target = Util.fileFromURI((String)CFG_FILE);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Config.Sources(value={"file:target/examples-generated-resources/HotReloadExample.properties"})
    @Config.HotReload(value=1L)
    static interface AutoReloadConfig
    extends Config,
    Reloadable {
        @Config.DefaultValue(value="5")
        public Integer someValue();
    }
}

