/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.dmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.activiti.dmn.model.Decision;
import org.activiti.dmn.model.DecisionRule;
import org.activiti.dmn.model.DecisionTable;
import org.activiti.dmn.model.DecisionTableOrientation;
import org.activiti.dmn.model.DmnDefinition;
import org.activiti.dmn.model.HitPolicy;
import org.activiti.dmn.model.InputClause;
import org.activiti.dmn.model.LiteralExpression;
import org.activiti.dmn.model.OutputClause;
import org.activiti.dmn.model.RuleInputClauseContainer;
import org.activiti.dmn.model.RuleOutputClauseContainer;
import org.activiti.dmn.model.UnaryTests;
import org.activiti.editor.dmn.converter.DmnJsonConverterUtil;

public class DmnJsonConverter {
    public static final String MODEL_NAMESPACE = "http://activiti.com/dmn";
    public static final String URI_JSON = "http://www.ecma-international.org/ecma-404/";
    protected ObjectMapper objectMapper = new ObjectMapper();

    public DmnDefinition convertToDmn(JsonNode modelNode, Long modelId, int modelVersion, Date lastUpdated) {
        DmnDefinition definition = new DmnDefinition();
        definition.setId("definition_" + String.valueOf(modelId));
        definition.setName(DmnJsonConverterUtil.getValueAsString("name", modelNode));
        definition.setNamespace(MODEL_NAMESPACE);
        definition.setTypeLanguage(URI_JSON);
        Decision decision = new Decision();
        decision.setId(DmnJsonConverterUtil.getValueAsString("key", modelNode));
        decision.setName(DmnJsonConverterUtil.getValueAsString("name", modelNode));
        decision.setDescription(DmnJsonConverterUtil.getValueAsString("description", modelNode));
        definition.addDrgElement(decision);
        DecisionTable decisionTable = new DecisionTable();
        decisionTable.setId("decisionTable_" + DmnJsonConverterUtil.getValueAsString("id", modelNode));
        if (modelNode.has("hitIndicator")) {
            decisionTable.setHitPolicy(HitPolicy.valueOf((String)DmnJsonConverterUtil.getValueAsString("hitIndicator", modelNode)));
        } else {
            decisionTable.setHitPolicy(HitPolicy.FIRST);
        }
        decisionTable.setPreferredOrientation(DecisionTableOrientation.RULE_AS_ROW);
        decision.setDecisionTable(decisionTable);
        definition.setCurrentDecisionTable(decisionTable);
        this.processDecisionTable(modelNode, definition, decisionTable);
        return definition;
    }

    public ObjectNode convertToJson(DmnDefinition definition) {
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        modelNode.put("id", definition.getId());
        modelNode.put("key", ((Decision)definition.getDrgElements().get(0)).getId());
        modelNode.put("name", definition.getName());
        modelNode.put("description", definition.getDescription());
        modelNode.put("hitIndicator", definition.getCurrentDecisionTable().getHitPolicy().name());
        HashMap<String, InputClause> inputClauseMap = new HashMap<String, InputClause>();
        ArrayNode inputExpressionsNode = this.objectMapper.createArrayNode();
        for (InputClause clause : definition.getCurrentDecisionTable().getInputs()) {
            LiteralExpression inputExpression = clause.getInputExpression();
            inputClauseMap.put(inputExpression.getId(), clause);
            ObjectNode inputExpressionNode = this.objectMapper.createObjectNode();
            inputExpressionNode.put("id", inputExpression.getId());
            inputExpressionNode.put("type", inputExpression.getTypeRef());
            inputExpressionNode.put("label", inputExpression.getLabel());
            inputExpressionNode.put("variableId", inputExpression.getText());
            inputExpressionsNode.add((JsonNode)inputExpressionNode);
        }
        modelNode.put("inputExpressions", (JsonNode)inputExpressionsNode);
        HashMap<String, OutputClause> outputClauseMap = new HashMap<String, OutputClause>();
        ArrayNode outputExpressionsNode = this.objectMapper.createArrayNode();
        for (OutputClause clause : definition.getCurrentDecisionTable().getOutputs()) {
            outputClauseMap.put(clause.getId(), clause);
            ObjectNode outputExpressionNode = this.objectMapper.createObjectNode();
            outputExpressionNode.put("id", clause.getId());
            outputExpressionNode.put("type", clause.getTypeRef());
            outputExpressionNode.put("label", clause.getLabel());
            outputExpressionNode.put("variableId", clause.getName());
            outputExpressionsNode.add((JsonNode)outputExpressionNode);
        }
        modelNode.put("outputExpressions", (JsonNode)outputExpressionsNode);
        ArrayNode rulesNode = this.objectMapper.createArrayNode();
        for (DecisionRule rule : definition.getCurrentDecisionTable().getRules()) {
            ObjectNode ruleNode = this.objectMapper.createObjectNode();
            for (RuleInputClauseContainer ruleClauseContainer : rule.getInputEntries()) {
                InputClause inputClause = ruleClauseContainer.getInputClause();
                UnaryTests inputEntry = ruleClauseContainer.getInputEntry();
                ruleNode.put(inputClause.getInputExpression().getId(), inputEntry.getText());
            }
            for (RuleInputClauseContainer ruleClauseContainer : rule.getOutputEntries()) {
                OutputClause outputClause = ruleClauseContainer.getOutputClause();
                LiteralExpression outputEntry = ruleClauseContainer.getOutputEntry();
                ruleNode.put(outputClause.getId(), outputEntry.getText());
            }
            rulesNode.add((JsonNode)ruleNode);
        }
        modelNode.put("rules", (JsonNode)rulesNode);
        return modelNode;
    }

    protected void processDecisionTable(JsonNode modelNode, DmnDefinition definition, DecisionTable decisionTable) {
        JsonNode rules;
        JsonNode outputExpressions;
        if (definition == null || decisionTable == null) {
            return;
        }
        LinkedHashMap<String, InputClause> ruleInputContainerMap = new LinkedHashMap<String, InputClause>();
        LinkedHashMap<String, OutputClause> ruleOutputContainerMap = new LinkedHashMap<String, OutputClause>();
        JsonNode inputExpressions = modelNode.get("inputExpressions");
        if (inputExpressions != null && !inputExpressions.isNull()) {
            for (Iterator inputExpressionNode : inputExpressions) {
                InputClause inputClause = new InputClause();
                inputClause.setLabel(DmnJsonConverterUtil.getValueAsString("label", (JsonNode)inputExpressionNode));
                String inputExpressionId = DmnJsonConverterUtil.getValueAsString("id", (JsonNode)inputExpressionNode);
                LiteralExpression inputExpression = new LiteralExpression();
                inputExpression.setId("inputExpression_" + inputExpressionId);
                inputExpression.setTypeRef(DmnJsonConverterUtil.getValueAsString("type", (JsonNode)inputExpressionNode));
                inputExpression.setLabel(DmnJsonConverterUtil.getValueAsString("label", (JsonNode)inputExpressionNode));
                inputExpression.setText(DmnJsonConverterUtil.getValueAsString("variableId", (JsonNode)inputExpressionNode));
                inputClause.setInputExpression(inputExpression);
                ruleInputContainerMap.put(inputExpressionId, inputClause);
                decisionTable.addInput(inputClause);
            }
        }
        if ((outputExpressions = modelNode.get("outputExpressions")) != null && !outputExpressions.isNull()) {
            for (JsonNode outputExpressionNode : outputExpressions) {
                OutputClause outputClause = new OutputClause();
                String outputExpressionId = DmnJsonConverterUtil.getValueAsString("id", outputExpressionNode);
                outputClause.setId("outputExpression_" + outputExpressionId);
                outputClause.setLabel(DmnJsonConverterUtil.getValueAsString("label", outputExpressionNode));
                outputClause.setName(DmnJsonConverterUtil.getValueAsString("variableId", outputExpressionNode));
                outputClause.setTypeRef(DmnJsonConverterUtil.getValueAsString("type", outputExpressionNode));
                ruleOutputContainerMap.put(outputExpressionId, outputClause);
                decisionTable.addOutput(outputClause);
            }
        }
        if ((rules = modelNode.get("rules")) != null && !rules.isNull()) {
            int ruleCounter = 1;
            for (JsonNode ruleNode : rules) {
                DecisionRule rule = new DecisionRule();
                for (String id : ruleInputContainerMap.keySet()) {
                    if (!ruleNode.has(id)) continue;
                    RuleInputClauseContainer ruleInputClauseContainer = new RuleInputClauseContainer();
                    ruleInputClauseContainer.setInputClause((InputClause)ruleInputContainerMap.get(id));
                    UnaryTests inputEntry = new UnaryTests();
                    inputEntry.setId("inputEntry_" + id + "_" + ruleCounter);
                    inputEntry.setText(ruleNode.get(id).asText());
                    ruleInputClauseContainer.setInputEntry(inputEntry);
                    rule.addInputEntry(ruleInputClauseContainer);
                }
                for (String id : ruleOutputContainerMap.keySet()) {
                    if (!ruleNode.has(id)) continue;
                    RuleOutputClauseContainer ruleOutputClauseContainer = new RuleOutputClauseContainer();
                    ruleOutputClauseContainer.setOutputClause((OutputClause)ruleOutputContainerMap.get(id));
                    LiteralExpression outputEntry = new LiteralExpression();
                    outputEntry.setId("outputEntry_" + id + "_" + ruleCounter);
                    outputEntry.setText(ruleNode.get(id).asText());
                    ruleOutputClauseContainer.setOutputEntry(outputEntry);
                    rule.addOutputEntry(ruleOutputClauseContainer);
                }
                ++ruleCounter;
                decisionTable.addRule(rule);
            }
        }
    }

    private class RuleMapping {
        private String expressionValue;
        private String expressionId;
        private boolean isCondition;

        public RuleMapping(String expressionValue) {
            this.expressionValue = expressionValue;
        }

        public String getExpressionValue() {
            return this.expressionValue;
        }

        public String getExpressionId() {
            return this.expressionId;
        }

        public void setExpressionId(String expressionId) {
            this.expressionId = expressionId;
        }

        public boolean isCondition() {
            return this.isCondition;
        }

        public void setIsCondition(boolean isCondition) {
            this.isCondition = isCondition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleMapping that = (RuleMapping)o;
            return this.expressionValue.equals(that.expressionValue);
        }

        public int hashCode() {
            return this.expressionValue.hashCode();
        }
    }
}

