/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskVariablePayload;
import org.activiti.api.task.model.payloads.SaveTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskVariablePayload;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.runtime.api.impl.TaskVariablesPayloadValidator;
import org.activiti.runtime.api.model.impl.APITaskConverter;

public class TaskRuntimeHelper {
    private final TaskService taskService;
    private final SecurityManager securityManager;
    private final APITaskConverter taskConverter;
    private final TaskVariablesPayloadValidator taskVariablesValidator;

    public TaskRuntimeHelper(TaskService taskService, APITaskConverter taskConverter, SecurityManager securityManager, TaskVariablesPayloadValidator taskVariablesValidator) {
        this.taskService = taskService;
        this.securityManager = securityManager;
        this.taskConverter = taskConverter;
        this.taskVariablesValidator = taskVariablesValidator;
    }

    public org.activiti.api.task.model.Task applyUpdateTaskPayload(boolean isAdmin, UpdateTaskPayload updateTaskPayload) {
        Task internalTask = isAdmin ? this.getInternalTask(updateTaskPayload.getTaskId()) : this.getTaskToUpdate(updateTaskPayload.getTaskId());
        int updates = this.updateName(updateTaskPayload, internalTask, 0);
        updates = this.updateDescription(updateTaskPayload, internalTask, updates);
        updates = this.updatePriority(updateTaskPayload, internalTask, updates);
        updates = this.updateDueDate(updateTaskPayload, internalTask, updates);
        updates = this.updateParentTaskId(updateTaskPayload, internalTask, updates);
        if ((updates = this.updateFormKey(updateTaskPayload, internalTask, updates)) > 0) {
            this.taskService.saveTask(internalTask);
        }
        return this.taskConverter.from(this.getInternalTask(updateTaskPayload.getTaskId()));
    }

    private Task getTaskToUpdate(String taskId) {
        Task internalTask = this.getInternalTaskWithChecks(taskId);
        this.assertCanModifyTask(internalTask);
        return internalTask;
    }

    private void assertCanModifyTask(Task internalTask) {
        String authenticatedUserId = this.getAuthenticatedUser();
        if (!Objects.equals(internalTask.getAssignee(), authenticatedUserId)) {
            throw new IllegalStateException("You cannot update a task where you are not the assignee");
        }
    }

    private int updateFormKey(UpdateTaskPayload updateTaskPayload, Task internalTask, int updates) {
        String oldValue;
        String newValue = updateTaskPayload.getFormKey();
        if (newValue != null && !Objects.equals(oldValue = internalTask.getFormKey(), newValue)) {
            ++updates;
            internalTask.setFormKey(newValue);
        }
        return updates;
    }

    private int updateParentTaskId(UpdateTaskPayload updateTaskPayload, Task internalTask, int updates) {
        String oldValue;
        String newValue = updateTaskPayload.getParentTaskId();
        if (newValue != null && !Objects.equals(oldValue = internalTask.getParentTaskId(), newValue)) {
            ++updates;
            internalTask.setParentTaskId(newValue);
        }
        return updates;
    }

    private int updateDueDate(UpdateTaskPayload updateTaskPayload, Task internalTask, int updates) {
        if (updateTaskPayload.getDueDate() != null && !Objects.equals(internalTask.getDueDate(), updateTaskPayload.getDueDate())) {
            ++updates;
            internalTask.setDueDate(updateTaskPayload.getDueDate());
        }
        return updates;
    }

    private int updatePriority(UpdateTaskPayload updateTaskPayload, Task internalTask, int updates) {
        if (updateTaskPayload.getPriority() != null && internalTask.getPriority() != updateTaskPayload.getPriority().intValue()) {
            ++updates;
            internalTask.setPriority(updateTaskPayload.getPriority().intValue());
        }
        return updates;
    }

    private int updateDescription(UpdateTaskPayload updateTaskPayload, Task internalTask, int updates) {
        String oldValue;
        String newValue = updateTaskPayload.getDescription();
        if (newValue != null && !Objects.equals(oldValue = internalTask.getDescription(), newValue)) {
            ++updates;
            internalTask.setDescription(newValue);
        }
        return updates;
    }

    private int updateName(UpdateTaskPayload updateTaskPayload, Task internalTask, int updates) {
        String oldValue;
        String newValue = updateTaskPayload.getName();
        if (newValue != null && !Objects.equals(oldValue = internalTask.getName(), newValue)) {
            ++updates;
            internalTask.setName(newValue);
        }
        return updates;
    }

    public Task getInternalTaskWithChecks(String taskId) {
        String authenticatedUserId = this.getAuthenticatedUser();
        if (authenticatedUserId != null && !authenticatedUserId.isEmpty() && this.securityManager != null) {
            List userRoles = this.securityManager.getAuthenticatedUserRoles();
            List userGroups = this.securityManager.getAuthenticatedUserGroups();
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(authenticatedUserId, userGroups).taskId(taskId)).singleResult();
            if (task == null) {
                throw new NotFoundException("Unable to find task for the given id: " + taskId + " for user: " + authenticatedUserId + " (with groups: " + userGroups + " & with roles: " + userRoles + ")");
            }
            return task;
        }
        throw new IllegalStateException("There is no authenticated user, we need a user authenticated to find tasks");
    }

    public void assertHasAccessToTask(String taskId) {
        this.getInternalTaskWithChecks(taskId);
    }

    private String getAuthenticatedUser() {
        return this.securityManager != null ? this.securityManager.getAuthenticatedUserId() : null;
    }

    public Task getInternalTask(String taskId) {
        Task internalTask = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (internalTask == null) {
            throw new NotFoundException("Unable to find task for the given id: " + taskId);
        }
        return internalTask;
    }

    public Map<String, VariableInstance> getInternalTaskVariables(String taskId) {
        return this.taskService.getVariableInstancesLocal(taskId);
    }

    public void createVariable(boolean isAdmin, CreateTaskVariablePayload createTaskVariablePayload) {
        if (!isAdmin) {
            this.assertCanModifyTask(this.getInternalTask(createTaskVariablePayload.getTaskId()));
        }
        this.taskVariablesValidator.handleCreateTaskVariablePayload(createTaskVariablePayload);
        this.assertVariableDoesNotExist(createTaskVariablePayload);
        this.taskService.setVariableLocal(createTaskVariablePayload.getTaskId(), createTaskVariablePayload.getName(), createTaskVariablePayload.getValue());
    }

    private void assertVariableDoesNotExist(CreateTaskVariablePayload createTaskVariablePayload) {
        Map variables = this.taskService.getVariableInstancesLocal(createTaskVariablePayload.getTaskId());
        if (variables != null && variables.containsKey(createTaskVariablePayload.getName())) {
            throw new IllegalStateException("Variable already exists");
        }
    }

    public void updateVariable(boolean isAdmin, UpdateTaskVariablePayload updateTaskVariablePayload) {
        if (!isAdmin) {
            this.assertCanModifyTask(this.getInternalTask(updateTaskVariablePayload.getTaskId()));
        }
        this.taskVariablesValidator.handleUpdateTaskVariablePayload(updateTaskVariablePayload);
        this.assertVariableExists(updateTaskVariablePayload);
        this.taskService.setVariableLocal(updateTaskVariablePayload.getTaskId(), updateTaskVariablePayload.getName(), updateTaskVariablePayload.getValue());
    }

    private void assertVariableExists(UpdateTaskVariablePayload updateTaskVariablePayload) {
        Map variables = this.taskService.getVariableInstancesLocal(updateTaskVariablePayload.getTaskId());
        if (variables == null) {
            throw new IllegalStateException("Variable does not exist");
        }
        if (!variables.containsKey(updateTaskVariablePayload.getName())) {
            throw new IllegalStateException("Variable does not exist");
        }
    }

    public void handleCompleteTaskPayload(CompleteTaskPayload completeTaskPayload) {
        completeTaskPayload.setVariables(this.taskVariablesValidator.handlePayloadVariables(completeTaskPayload.getVariables()));
    }

    public void handleSaveTaskPayload(SaveTaskPayload saveTaskPayload) {
        saveTaskPayload.setVariables(this.taskVariablesValidator.handlePayloadVariables(saveTaskPayload.getVariables()));
    }
}

