/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.builders.ProcessPayloadBuilder;
import org.activiti.api.process.model.payloads.DeleteProcessPayload;
import org.activiti.api.process.model.payloads.GetProcessDefinitionsPayload;
import org.activiti.api.process.model.payloads.GetProcessInstancesPayload;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.api.process.model.payloads.RemoveProcessVariablesPayload;
import org.activiti.api.process.model.payloads.ResumeProcessPayload;
import org.activiti.api.process.model.payloads.SetProcessVariablesPayload;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.api.process.model.payloads.StartMessagePayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.SuspendProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.api.process.runtime.ProcessAdminRuntime;
import org.activiti.api.runtime.model.impl.ProcessInstanceImpl;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.runtime.shared.query.Pageable;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.runtime.api.impl.ProcessVariablesPayloadValidator;
import org.activiti.runtime.api.model.impl.APIProcessDefinitionConverter;
import org.activiti.runtime.api.model.impl.APIProcessInstanceConverter;
import org.activiti.runtime.api.query.impl.PageImpl;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@PreAuthorize(value="hasRole('ACTIVITI_ADMIN')")
public class ProcessAdminRuntimeImpl
implements ProcessAdminRuntime {
    private final RepositoryService repositoryService;
    private final APIProcessDefinitionConverter processDefinitionConverter;
    private final RuntimeService runtimeService;
    private final APIProcessInstanceConverter processInstanceConverter;
    private final ApplicationEventPublisher eventPublisher;
    private final ProcessVariablesPayloadValidator processVariablesValidator;

    public ProcessAdminRuntimeImpl(RepositoryService repositoryService, APIProcessDefinitionConverter processDefinitionConverter, RuntimeService runtimeService, APIProcessInstanceConverter processInstanceConverter, ApplicationEventPublisher eventPublisher, ProcessVariablesPayloadValidator processVariablesValidator) {
        this.repositoryService = repositoryService;
        this.processDefinitionConverter = processDefinitionConverter;
        this.runtimeService = runtimeService;
        this.processInstanceConverter = processInstanceConverter;
        this.eventPublisher = eventPublisher;
        this.processVariablesValidator = processVariablesValidator;
    }

    public org.activiti.api.process.model.ProcessDefinition processDefinition(String processDefinitionId) {
        List list = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionId).orderByProcessDefinitionVersion().asc()).list();
        ProcessDefinition processDefinition = !list.isEmpty() ? (ProcessDefinition)list.get(0) : this.repositoryService.getProcessDefinition(processDefinitionId);
        return this.processDefinitionConverter.from(processDefinition);
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable) {
        return this.processDefinitions(pageable, ProcessPayloadBuilder.processDefinitions().build());
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable, GetProcessDefinitionsPayload getProcessDefinitionsPayload) {
        if (getProcessDefinitionsPayload == null) {
            throw new IllegalStateException("payload cannot be null");
        }
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (getProcessDefinitionsPayload.hasDefinitionKeys()) {
            processDefinitionQuery.processDefinitionKeys(getProcessDefinitionsPayload.getProcessDefinitionKeys());
        }
        return new PageImpl(this.processDefinitionConverter.from(processDefinitionQuery.list()), Math.toIntExact(processDefinitionQuery.count()));
    }

    public ProcessInstance start(StartProcessPayload startProcessPayload) {
        org.activiti.api.process.model.ProcessDefinition processDefinition = null;
        if (startProcessPayload.getProcessDefinitionId() != null) {
            processDefinition = this.processDefinition(startProcessPayload.getProcessDefinitionId());
        }
        if (processDefinition == null && startProcessPayload.getProcessDefinitionKey() != null) {
            processDefinition = this.processDefinition(startProcessPayload.getProcessDefinitionKey());
        }
        if (processDefinition == null) {
            throw new IllegalStateException("At least Process Definition Id or Key needs to be provided to start a process");
        }
        this.processVariablesValidator.checkStartProcessPayloadVariables(startProcessPayload, processDefinition.getId());
        return this.processInstanceConverter.from(this.runtimeService.createProcessInstanceBuilder().processDefinitionId(processDefinition.getId()).processDefinitionKey(processDefinition.getKey()).businessKey(startProcessPayload.getBusinessKey()).variables(startProcessPayload.getVariables()).name(startProcessPayload.getName()).start());
    }

    public Page<ProcessInstance> processInstances(Pageable pageable) {
        return this.processInstances(pageable, null);
    }

    public ProcessInstance processInstance(String processInstanceId) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = (org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (internalProcessInstance == null) {
            throw new NotFoundException("Unable to find process instance for the given id:'" + processInstanceId + "'");
        }
        return this.processInstanceConverter.from(internalProcessInstance);
    }

    public Page<ProcessInstance> processInstances(Pageable pageable, GetProcessInstancesPayload getProcessInstancesPayload) {
        ProcessInstanceQuery internalQuery = this.runtimeService.createProcessInstanceQuery();
        if (getProcessInstancesPayload != null) {
            if (getProcessInstancesPayload.getProcessDefinitionKeys() != null && !getProcessInstancesPayload.getProcessDefinitionKeys().isEmpty()) {
                internalQuery.processDefinitionKeys(getProcessInstancesPayload.getProcessDefinitionKeys());
            }
            if (getProcessInstancesPayload.getBusinessKey() != null && !getProcessInstancesPayload.getBusinessKey().isEmpty()) {
                internalQuery.processInstanceBusinessKey(getProcessInstancesPayload.getBusinessKey());
            }
            if (getProcessInstancesPayload.isSuspendedOnly()) {
                internalQuery.suspended();
            }
            if (getProcessInstancesPayload.isActiveOnly()) {
                internalQuery.active();
            }
            if (getProcessInstancesPayload.getParentProcessInstanceId() != null) {
                internalQuery.superProcessInstanceId(getProcessInstancesPayload.getParentProcessInstanceId());
            }
        }
        return new PageImpl(this.processInstanceConverter.from(internalQuery.listPage(pageable.getStartIndex(), pageable.getMaxItems())), Math.toIntExact(internalQuery.count()));
    }

    public ProcessInstance delete(DeleteProcessPayload deleteProcessPayload) {
        ProcessInstanceImpl processInstance = (ProcessInstanceImpl)this.processInstance(deleteProcessPayload.getProcessInstanceId());
        this.runtimeService.deleteProcessInstance(deleteProcessPayload.getProcessInstanceId(), deleteProcessPayload.getReason());
        if (processInstance != null) {
            processInstance.setStatus(ProcessInstance.ProcessInstanceStatus.CANCELLED);
            return processInstance;
        }
        return null;
    }

    @Transactional
    public void signal(SignalPayload signalPayload) {
        this.processVariablesValidator.checkSignalPayloadVariables(signalPayload, null);
        this.eventPublisher.publishEvent((Object)signalPayload);
    }

    public ProcessInstance suspend(SuspendProcessPayload suspendProcessPayload) {
        this.runtimeService.suspendProcessInstanceById(suspendProcessPayload.getProcessInstanceId());
        return this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(suspendProcessPayload.getProcessInstanceId()).singleResult());
    }

    public ProcessInstance resume(ResumeProcessPayload resumeProcessPayload) {
        this.runtimeService.activateProcessInstanceById(resumeProcessPayload.getProcessInstanceId());
        return this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(resumeProcessPayload.getProcessInstanceId()).singleResult());
    }

    public ProcessInstance update(UpdateProcessPayload updateProcessPayload) {
        if (updateProcessPayload.getBusinessKey() != null) {
            this.runtimeService.updateBusinessKey(updateProcessPayload.getProcessInstanceId(), updateProcessPayload.getBusinessKey());
        }
        if (updateProcessPayload.getName() != null) {
            this.runtimeService.setProcessInstanceName(updateProcessPayload.getProcessInstanceId(), updateProcessPayload.getName());
        }
        return this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(updateProcessPayload.getProcessInstanceId()).singleResult());
    }

    public void setVariables(SetProcessVariablesPayload setProcessVariablesPayload) {
        ProcessInstanceImpl processInstance = (ProcessInstanceImpl)this.processInstance(setProcessVariablesPayload.getProcessInstanceId());
        this.processVariablesValidator.checkPayloadVariables(setProcessVariablesPayload, processInstance.getProcessDefinitionId());
        this.runtimeService.setVariables(setProcessVariablesPayload.getProcessInstanceId(), setProcessVariablesPayload.getVariables());
    }

    public void removeVariables(RemoveProcessVariablesPayload removeProcessVariablesPayload) {
        this.runtimeService.removeVariables(removeProcessVariablesPayload.getProcessInstanceId(), (Collection)removeProcessVariablesPayload.getVariableNames());
    }

    @Transactional
    public void receive(ReceiveMessagePayload messagePayload) {
        this.processVariablesValidator.checkReceiveMessagePayloadVariables(messagePayload, null);
        this.eventPublisher.publishEvent((Object)messagePayload);
    }

    public ProcessInstance start(StartMessagePayload messagePayload) {
        String messageName = messagePayload.getName();
        String businessKey = messagePayload.getBusinessKey();
        Map variables = messagePayload.getVariables();
        this.processVariablesValidator.checkStartMessagePayloadVariables(messagePayload, null);
        ProcessInstance processInstance = this.processInstanceConverter.from(this.runtimeService.startProcessInstanceByMessage(messageName, businessKey, variables));
        return processInstance;
    }
}

