/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.x509.cache;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.acegisecurity.providers.x509.X509UserCache;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

public class EhCacheBasedX509UserCache
implements X509UserCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache == null ? (class$org$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache = EhCacheBasedX509UserCache.class$("org.acegisecurity.providers.x509.cache.EhCacheBasedX509UserCache")) : class$org$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache));
    private Ehcache cache;
    static /* synthetic */ Class class$org$acegisecurity$providers$x509$cache$EhCacheBasedX509UserCache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache is mandatory");
    }

    public UserDetails getUserFromCache(X509Certificate userCert) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)userCert);
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (logger.isDebugEnabled()) {
            String subjectDN = "unknown";
            if (userCert != null && userCert.getSubjectDN() != null) {
                subjectDN = ((Object)userCert.getSubjectDN()).toString();
            }
            logger.debug((Object)("X.509 Cache hit. SubjectDN: " + subjectDN));
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.getValue();
    }

    public void putUserInCache(X509Certificate userCert, UserDetails user) {
        Element element = new Element((Serializable)userCert, (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + userCert.getSubjectDN()));
        }
        this.cache.put(element);
    }

    public void removeUserFromCache(X509Certificate userCert) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + userCert.getSubjectDN()));
        }
        this.cache.remove((Serializable)userCert);
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

