/* Copyright 2004, 2005, 2006 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.acegisecurity.acls.jdbc;

import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;

import java.io.Serializable;


/**
 * A caching layer for {@link JdbcAclService}.
 * 
 * @author Ben Alex
 * @version $Id: AclCache.java 1754 2006-11-17 02:01:21Z benalex $
 *
 */
public interface AclCache {
    //~ Methods ========================================================================================================

    public void evictFromCache(Serializable pk);

    public void evictFromCache(ObjectIdentity objectIdentity);

    public MutableAcl getFromCache(ObjectIdentity objectIdentity);

    public MutableAcl getFromCache(Serializable pk);

    public void putInCache(MutableAcl acl);
}
