/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout.demo.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.demo.TextInBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextInBoxTreePane
extends JComponent {
    private final TreeLayout<TextInBox> treeLayout;
    private static final int ARC_SIZE = 10;
    private static final Color BOX_COLOR = Color.orange;
    private static final Color BORDER_COLOR = Color.darkGray;
    private static final Color TEXT_COLOR = Color.black;

    private TreeForTreeLayout<TextInBox> getTree() {
        return this.treeLayout.getTree();
    }

    private Iterable<TextInBox> getChildren(TextInBox parent) {
        return this.getTree().getChildren((Object)parent);
    }

    private Rectangle2D.Double getBoundsOfNode(TextInBox node) {
        return (Rectangle2D.Double)this.treeLayout.getNodeBounds().get(node);
    }

    public TextInBoxTreePane(TreeLayout<TextInBox> treeLayout) {
        this.treeLayout = treeLayout;
        Dimension size = treeLayout.getBounds().getBounds().getSize();
        this.setPreferredSize(size);
    }

    private void paintEdges(Graphics g, TextInBox parent) {
        if (!this.getTree().isLeaf((Object)parent)) {
            Rectangle2D.Double b1 = this.getBoundsOfNode(parent);
            double x1 = b1.getCenterX();
            double y1 = b1.getCenterY();
            for (TextInBox child : this.getChildren(parent)) {
                Rectangle2D.Double b2 = this.getBoundsOfNode(child);
                g.drawLine((int)x1, (int)y1, (int)b2.getCenterX(), (int)b2.getCenterY());
                this.paintEdges(g, child);
            }
        }
    }

    private void paintBox(Graphics g, TextInBox textInBox) {
        g.setColor(BOX_COLOR);
        Rectangle2D.Double box = this.getBoundsOfNode(textInBox);
        g.fillRoundRect((int)box.x, (int)box.y, (int)box.width - 1, (int)box.height - 1, 10, 10);
        g.setColor(BORDER_COLOR);
        g.drawRoundRect((int)box.x, (int)box.y, (int)box.width - 1, (int)box.height - 1, 10, 10);
        g.setColor(TEXT_COLOR);
        String[] lines = textInBox.text.split("\n");
        FontMetrics m = this.getFontMetrics(this.getFont());
        int x = (int)box.x + 5;
        int y = (int)box.y + m.getAscent() + m.getLeading() + 1;
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], x, y);
            y += m.getHeight();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintEdges(g, (TextInBox)this.getTree().getRoot());
        for (TextInBox textInBox : this.treeLayout.getNodeBounds().keySet()) {
            this.paintBox(g, textInBox);
        }
    }
}

