/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout.demo.swing;

import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.demo.SampleTreeFactory;
import org.abego.treelayout.demo.TextInBox;
import org.abego.treelayout.demo.TextInBoxNodeExtentProvider;
import org.abego.treelayout.demo.swing.TextInBoxTreePane;
import org.abego.treelayout.util.DefaultConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingDemo {
    private static void showInDialog(JComponent panel) {
        JDialog dialog = new JDialog();
        Container contentPane = dialog.getContentPane();
        ((JComponent)contentPane).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private static TreeForTreeLayout<TextInBox> getSampleTree(String treeName) {
        TreeForTreeLayout<TextInBox> tree;
        if (treeName.equals("2")) {
            tree = SampleTreeFactory.createSampleTree2();
        } else if (treeName.equals("")) {
            tree = SampleTreeFactory.createSampleTree();
        } else {
            throw new RuntimeException(String.format("Invalid tree name: '%s'", treeName));
        }
        return tree;
    }

    public static void main(String[] args) {
        String treeName = args.length > 0 ? args[0] : "";
        TreeForTreeLayout<TextInBox> tree = SwingDemo.getSampleTree(treeName);
        double gapBetweenLevels = 50.0;
        double gapBetweenNodes = 10.0;
        DefaultConfiguration configuration = new DefaultConfiguration(gapBetweenLevels, gapBetweenNodes);
        TextInBoxNodeExtentProvider nodeExtentProvider = new TextInBoxNodeExtentProvider();
        TreeLayout treeLayout = new TreeLayout(tree, (NodeExtentProvider)nodeExtentProvider, (Configuration)configuration);
        TextInBoxTreePane panel = new TextInBoxTreePane((TreeLayout<TextInBox>)treeLayout);
        SwingDemo.showInDialog(panel);
    }
}

