/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout.demo.svg;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.demo.TextInBox;
import org.abego.treelayout.demo.svg.SVGUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGForTextInBoxTree {
    private final TreeLayout<TextInBox> treeLayout;
    private String svgText;

    private TreeForTreeLayout<TextInBox> getTree() {
        return this.treeLayout.getTree();
    }

    private Iterable<TextInBox> getChildren(TextInBox parent) {
        return this.getTree().getChildren((Object)parent);
    }

    private Rectangle2D.Double getBoundsOfNode(TextInBox node) {
        return (Rectangle2D.Double)this.treeLayout.getNodeBounds().get(node);
    }

    public SVGForTextInBoxTree(TreeLayout<TextInBox> treeLayout) {
        this.treeLayout = treeLayout;
    }

    private void generateEdges(StringBuilder result, TextInBox parent) {
        if (!this.getTree().isLeaf((Object)parent)) {
            Rectangle2D.Double b1 = this.getBoundsOfNode(parent);
            double x1 = b1.getCenterX();
            double y1 = b1.getCenterY();
            for (TextInBox child : this.getChildren(parent)) {
                Rectangle2D.Double b2 = this.getBoundsOfNode(child);
                result.append(SVGUtil.line(x1, y1, b2.getCenterX(), b2.getCenterY(), "stroke:black; stroke-width:2px;"));
                this.generateEdges(result, child);
            }
        }
    }

    private void generateBox(StringBuilder result, TextInBox textInBox) {
        Rectangle2D.Double box = this.getBoundsOfNode(textInBox);
        result.append(SVGUtil.rect(box.x + 1.0, box.y + 1.0, box.width - 2.0, box.height - 2.0, "fill:orange; stroke:rgb(0,0,0);", "rx=\"10\""));
        String[] lines = textInBox.text.split("\n");
        int fontSize = 12;
        int x = (int)box.x + fontSize / 2 + 2;
        int y = (int)box.y + fontSize + 1;
        String style = String.format("font-family:sans-serif;font-size:%dpx;", fontSize);
        for (int i = 0; i < lines.length; ++i) {
            result.append(SVGUtil.text(x, y, style, lines[i]));
            y += fontSize;
        }
    }

    private String generateDiagram() {
        StringBuilder result = new StringBuilder();
        this.generateEdges(result, (TextInBox)this.getTree().getRoot());
        for (TextInBox textInBox : this.treeLayout.getNodeBounds().keySet()) {
            this.generateBox(result, textInBox);
        }
        Dimension size = this.treeLayout.getBounds().getBounds().getSize();
        return SVGUtil.svg(size.width, size.height, result.toString());
    }

    public String getSVG() {
        if (this.svgText == null) {
            this.svgText = SVGUtil.doc(this.generateDiagram());
        }
        return this.svgText;
    }
}

