/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkins.plugins.lockableresources.LockStep;
import org.jenkins.plugins.lockableresources.LockStepResource;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;

public class LockStepExecution
extends AbstractStepExecutionImpl
implements Serializable {
    private static final long serialVersionUID = 1391734561272059623L;
    private static final Logger LOGGER = Logger.getLogger(LockStepExecution.class.getName());
    private final LockStep step;

    public LockStepExecution(LockStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        this.step.validate();
        ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new PauseAction("Lock"));
        PrintStream logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
        logger.println("Trying to acquire lock on [" + this.step + "]");
        ArrayList<LockableResourcesStruct> resourceHolderList = new ArrayList<LockableResourcesStruct>();
        for (LockStepResource resource : this.step.getResources()) {
            ArrayList<String> resources = new ArrayList<String>();
            if (resource.resource != null) {
                if (LockableResourcesManager.get().createResource(resource.resource)) {
                    logger.println("Resource [" + resource + "] did not exist. Created.");
                }
                resources.add(resource.resource);
            }
            resourceHolderList.add(new LockableResourcesStruct(resources, resource.label, resource.quantity));
        }
        List<LockableResource> available = LockableResourcesManager.get().checkResourcesAvailability(resourceHolderList, logger, null, this.step.skipIfLocked);
        Run run = (Run)this.getContext().get(Run.class);
        if (available == null || !LockableResourcesManager.get().lock(available, run, this.getContext(), this.step.toString(), this.step.variable, this.step.inversePrecedence)) {
            boolean buildNameKnown;
            LockableResource resource = LockableResourcesManager.get().fromName(this.step.resource);
            boolean bl = buildNameKnown = resource != null && resource.getBuildName() != null;
            if (this.step.skipIfLocked) {
                if (buildNameKnown) {
                    logger.println("[" + this.step + "] is locked by " + resource.getBuildName() + ", skipping execution...");
                } else {
                    logger.println("[" + this.step + "] is locked, skipping execution...");
                }
                this.getContext().onSuccess(null);
                return true;
            }
            if (buildNameKnown) {
                logger.println("[" + this.step + "] is locked by " + resource.getBuildName() + ", waiting...");
            } else {
                logger.println("[" + this.step + "] is locked, waiting...");
            }
            LockableResourcesManager.get().queueContext(this.getContext(), resourceHolderList, this.step.toString(), this.step.variable);
        }
        return false;
    }

    public static void proceed(final List<String> resourceNames, StepContext context, String resourceDescription, final String variable, boolean inversePrecedence) {
        FlowNode node;
        Run r;
        try {
            r = (Run)context.get(Run.class);
            node = (FlowNode)context.get(FlowNode.class);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock acquired on [" + resourceDescription + "]");
        }
        catch (Exception e) {
            context.onFailure((Throwable)e);
            return;
        }
        LOGGER.finest("Lock acquired on [" + resourceDescription + "] by " + r.getExternalizableId());
        try {
            PauseAction.endCurrentPause((FlowNode)node);
            BodyInvoker bodyInvoker = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(resourceNames, resourceDescription, inversePrecedence));
            if (variable != null && variable.length() > 0) {
                bodyInvoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)new EnvironmentExpander(){
                    private static final long serialVersionUID = -3431466225193397896L;

                    public void expand(@NonNull EnvVars env) {
                        HashMap<String, String> variables = new HashMap<String, String>();
                        String resources = String.join((CharSequence)",", resourceNames);
                        variables.put(variable, resources);
                        for (int index = 0; index < resourceNames.size(); ++index) {
                            variables.put(variable + index, (String)resourceNames.get(index));
                        }
                        LOGGER.finest("Setting " + variables.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ")) + " for the duration of the block");
                        env.overrideAll(variables);
                    }
                }));
            }
            bodyInvoker.start();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(@NonNull Throwable cause) {
        boolean cleaned = LockableResourcesManager.get().unqueueContext(this.getContext());
        if (!cleaned) {
            LOGGER.log(Level.WARNING, "Cannot remove context from lockable resource waiting list. The context is not in the waiting list.");
        }
        this.getContext().onFailure(cause);
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = -2024890670461847666L;
        private final List<String> resourceNames;
        private final String resourceDescription;
        private final boolean inversePrecedence;

        Callback(List<String> resourceNames, String resourceDescription, boolean inversePrecedence) {
            this.resourceNames = resourceNames;
            this.resourceDescription = resourceDescription;
            this.inversePrecedence = inversePrecedence;
        }

        protected void finished(StepContext context) throws Exception {
            LockableResourcesManager.get().unlockNames(this.resourceNames, (Run)context.get(Run.class), this.inversePrecedence);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock released on resource [" + this.resourceDescription + "]");
            LOGGER.finest("Lock released on [" + this.resourceDescription + "]");
        }
    }
}

