/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkins.plugins.lockableresources.LockStepExecution;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.QueuedContextStruct;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class LockableResourcesManager
extends GlobalConfiguration {
    @Deprecated
    private transient int defaultPriority;
    @Deprecated
    private transient String priorityParameterName;
    private List<LockableResource> resources;
    private List<QueuedContextStruct> queuedContexts = new ArrayList<QueuedContextStruct>();
    private static final Logger LOGGER = Logger.getLogger(LockableResourcesManager.class.getName());

    public LockableResourcesManager() {
        this.resources = new ArrayList<LockableResource>();
        this.load();
    }

    public List<LockableResource> getResources() {
        return this.resources;
    }

    public List<LockableResource> getResourcesFromProject(String fullName) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            String rName = r.getQueueItemProject();
            if (rName == null || !rName.equals(fullName)) continue;
            matching.add(r);
        }
        return matching;
    }

    public List<LockableResource> getResourcesFromBuild(Run<?, ?> build) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            Run<?, ?> rBuild = r.getBuild();
            if (rBuild == null || rBuild != build) continue;
            matching.add(r);
        }
        return matching;
    }

    public Boolean isValidLabel(String label) {
        return this.getAllLabels().contains(label);
    }

    public Set<String> getAllLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (LockableResource r : this.resources) {
            String rl = r.getLabels();
            if (rl == null || "".equals(rl)) continue;
            labels.addAll(Arrays.asList(rl.split("\\s+")));
        }
        return labels;
    }

    public int getFreeResourceAmount(String label) {
        int free = 0;
        for (LockableResource r : this.resources) {
            if (r.isLocked() || r.isQueued() || r.isReserved() || !Arrays.asList(r.getLabels().split("\\s+")).contains(label)) continue;
            ++free;
        }
        return free;
    }

    public List<LockableResource> getResourcesWithLabel(String label, Map<String, Object> params) {
        ArrayList<LockableResource> found = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            if (!r.isValidLabel(label, params)) continue;
            found.add(r);
        }
        return found;
    }

    @Nonnull
    public List<LockableResource> getResourcesMatchingScript(@Nonnull SecureGroovyScript script, @CheckForNull Map<String, Object> params) throws ExecutionException {
        ArrayList<LockableResource> found = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            if (!r.scriptMatches(script, params)) continue;
            found.add(r);
        }
        return found;
    }

    public LockableResource fromName(String resourceName) {
        if (resourceName != null) {
            for (LockableResource r : this.resources) {
                if (!resourceName.equals(r.getName())) continue;
                return r;
            }
        }
        return null;
    }

    public synchronized boolean queue(List<LockableResource> resources, long queueItemId) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isQueued(queueItemId) && !r.isLocked()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.setQueued(queueItemId);
        }
        return true;
    }

    @Deprecated
    @CheckForNull
    public synchronized List<LockableResource> queue(LockableResourcesStruct requiredResources, long queueItemId, String queueItemProject, int number, Map<String, Object> params, Logger log) {
        try {
            return this.tryQueue(requiredResources, queueItemId, queueItemProject, number, params, log);
        }
        catch (ExecutionException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                String itemName = queueItemProject + " (id=" + queueItemId + ")";
                LOGGER.log(Level.WARNING, "Failed to queue item " + itemName, ex.getCause() != null ? ex.getCause() : ex);
            }
            return null;
        }
    }

    @CheckForNull
    public synchronized List<LockableResource> tryQueue(LockableResourcesStruct requiredResources, long queueItemId, String queueItemProject, int number, Map<String, Object> params, Logger log) throws ExecutionException {
        int required_amount;
        ArrayList<LockableResource> selected = new ArrayList<LockableResource>();
        if (!this.checkCurrentResourcesStatus(selected, queueItemProject, queueItemId, log)) {
            log.log(Level.FINEST, "{0} has another build waiting resources. Waiting for it to proceed first.", new Object[]{queueItemProject});
            return null;
        }
        List<Object> candidates = new ArrayList();
        SecureGroovyScript systemGroovyScript = requiredResources.getResourceMatchScript();
        candidates = requiredResources.label != null && requiredResources.label.isEmpty() && systemGroovyScript == null ? requiredResources.required : (systemGroovyScript == null ? this.getResourcesWithLabel(requiredResources.label, params) : this.getResourcesMatchingScript(systemGroovyScript, params));
        for (LockableResource lockableResource : candidates) {
            if (number != 0 && selected.size() >= number) break;
            if (lockableResource.isReserved() || lockableResource.isLocked() || lockableResource.isQueued()) continue;
            selected.add(lockableResource);
        }
        int n = required_amount = number == 0 ? candidates.size() : number;
        if (selected.size() != required_amount) {
            log.log(Level.FINEST, "{0} found {1} resource(s) to queue.Waiting for correct amount: {2}.", new Object[]{queueItemProject, selected.size(), required_amount});
            for (LockableResource x : this.resources) {
                if (x.getQueueItemProject() == null || !x.getQueueItemProject().equals(queueItemProject)) continue;
                x.unqueue();
            }
            return null;
        }
        for (LockableResource rsc : selected) {
            rsc.setQueued(queueItemId, queueItemProject);
        }
        return selected;
    }

    private boolean checkCurrentResourcesStatus(List<LockableResource> selected, String project, long taskId, Logger log) {
        for (LockableResource r : this.resources) {
            String rProject = r.getQueueItemProject();
            if (rProject == null || !rProject.equals(project)) continue;
            if (r.isQueuedByTask(taskId)) {
                selected.add(r);
                continue;
            }
            log.log(Level.FINEST, "{0} has another build that already queued resource {1}. Continue queueing.", new Object[]{project, r});
            return false;
        }
        return true;
    }

    public synchronized boolean lock(List<LockableResource> resources, Run<?, ?> build, @Nullable StepContext context) {
        return this.lock(resources, build, context, null, false);
    }

    public synchronized boolean lock(List<LockableResource> resources, Run<?, ?> build, @Nullable StepContext context, @Nullable String logmessage, boolean inversePrecedence) {
        boolean needToWait = false;
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isLocked()) continue;
            needToWait = true;
            break;
        }
        if (!needToWait) {
            for (LockableResource r : resources) {
                r.unqueue();
                r.setBuild(build);
            }
            if (context != null) {
                ArrayList<String> resourceNames = new ArrayList<String>();
                for (LockableResource resource : resources) {
                    resourceNames.add(resource.getName());
                }
                LockStepExecution.proceed(resourceNames, context, logmessage, inversePrecedence);
            }
        }
        this.save();
        return !needToWait;
    }

    private synchronized void freeResources(List<String> unlockResourceNames, @Nullable Run<?, ?> build) {
        for (String unlockResourceName : unlockResourceNames) {
            for (LockableResource resource : this.resources) {
                if (!resource.getName().equals(unlockResourceName) || build != null && (resource.getBuild() == null || !build.getExternalizableId().equals(resource.getBuild().getExternalizableId()))) continue;
                resource.unqueue();
                resource.setBuild(null);
            }
        }
    }

    public synchronized void unlock(List<LockableResource> resourcesToUnLock, @Nullable Run<?, ?> build) {
        this.unlock(resourcesToUnLock, build, false);
    }

    public synchronized void unlock(@Nullable List<LockableResource> resourcesToUnLock, @Nullable Run<?, ?> build, boolean inversePrecedence) {
        ArrayList<String> resourceNamesToUnLock = new ArrayList<String>();
        if (resourcesToUnLock != null) {
            for (LockableResource r : resourcesToUnLock) {
                resourceNamesToUnLock.add(r.getName());
            }
        }
        this.unlockNames(resourceNamesToUnLock, build, inversePrecedence);
    }

    public synchronized void unlockNames(@Nullable List<String> resourceNamesToUnLock, @Nullable Run<?, ?> build, boolean inversePrecedence) {
        if (resourceNamesToUnLock == null || resourceNamesToUnLock.size() == 0) {
            return;
        }
        List<LockableResource> requiredResourceForNextContext = null;
        QueuedContextStruct nextContext = this.getNextQueuedContext(resourceNamesToUnLock, inversePrecedence);
        if (nextContext == null) {
            this.freeResources(resourceNamesToUnLock, build);
            this.save();
            return;
        }
        requiredResourceForNextContext = this.checkResourcesAvailability(nextContext.getResources(), null, resourceNamesToUnLock);
        this.queuedContexts.remove(nextContext);
        boolean needToWait = false;
        for (LockableResource requiredResource : requiredResourceForNextContext) {
            if (resourceNamesToUnLock.contains(requiredResource.getName()) || !requiredResource.isReserved() && !requiredResource.isLocked()) continue;
            needToWait = true;
            break;
        }
        if (needToWait) {
            this.freeResources(resourceNamesToUnLock, build);
            this.save();
            return;
        }
        ArrayList<String> resourceNamesToLock = new ArrayList<String>();
        for (LockableResource requiredResource : requiredResourceForNextContext) {
            try {
                requiredResource.setBuild((Run)nextContext.getContext().get(Run.class));
                resourceNamesToLock.add(requiredResource.getName());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Skipping queued context for lock. Can not get the Run object from the context to proceed with lock, this could be a legitimate status if the build waiting for the lock was deleted or hard killed. More information at Level.FINE if debug is needed.");
                LOGGER.log(Level.FINE, "Can not get the Run object from the context to proceed with lock", e);
                this.unlockNames(resourceNamesToUnLock, build, inversePrecedence);
                return;
            }
        }
        ArrayList<String> freeResources = new ArrayList<String>();
        for (String resourceNameToUnlock : resourceNamesToUnLock) {
            boolean resourceStillNeeded = false;
            for (LockableResource requiredResource : requiredResourceForNextContext) {
                if (resourceNameToUnlock == null || !resourceNameToUnlock.equals(requiredResource.getName())) continue;
                resourceStillNeeded = true;
                break;
            }
            if (resourceStillNeeded) continue;
            freeResources.add(resourceNameToUnlock);
        }
        this.freeResources(freeResources, build);
        LockStepExecution.proceed(resourceNamesToLock, nextContext.getContext(), nextContext.getResourceDescription(), inversePrecedence);
        this.save();
    }

    @CheckForNull
    private QueuedContextStruct getNextQueuedContext(List<String> resourceNamesToUnLock, boolean inversePrecedence) {
        QueuedContextStruct newestEntry = null;
        Object requiredResourceForNextContext = null;
        if (!inversePrecedence) {
            for (QueuedContextStruct entry : this.queuedContexts) {
                if (this.checkResourcesAvailability(entry.getResources(), null, resourceNamesToUnLock) == null) continue;
                return entry;
            }
        } else {
            long newest = 0L;
            ArrayList<QueuedContextStruct> orphan = new ArrayList<QueuedContextStruct>();
            for (QueuedContextStruct entry : this.queuedContexts) {
                if (this.checkResourcesAvailability(entry.getResources(), null, resourceNamesToUnLock) == null) continue;
                try {
                    Run run = (Run)entry.getContext().get(Run.class);
                    if (run == null || run.getStartTimeInMillis() <= newest) continue;
                    newest = run.getStartTimeInMillis();
                    newestEntry = entry;
                }
                catch (IOException | InterruptedException e) {
                    orphan.add(entry);
                }
            }
            if (!orphan.isEmpty()) {
                this.queuedContexts.removeAll(orphan);
            }
        }
        return newestEntry;
    }

    public synchronized boolean createResource(String name) {
        LockableResource existent = this.fromName(name);
        if (existent == null) {
            this.getResources().add(new LockableResource(name));
            this.save();
            return true;
        }
        return false;
    }

    public synchronized boolean createResourceWithLabel(String name, String label) {
        LockableResource existent = this.fromName(name);
        if (existent == null) {
            this.getResources().add(new LockableResource(name, "", label, null));
            this.save();
            return true;
        }
        return false;
    }

    public synchronized boolean reserve(List<LockableResource> resources, String userName) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isLocked() && !r.isQueued()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.setReservedBy(userName);
        }
        this.save();
        return true;
    }

    public synchronized void unreserve(List<LockableResource> resources) {
        for (LockableResource r : resources) {
            r.unReserve();
        }
        this.save();
    }

    public String getDisplayName() {
        return "External Resources";
    }

    public synchronized void reset(List<LockableResource> resources) {
        for (LockableResource r : resources) {
            r.reset();
        }
        this.save();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            List newResouces = req.bindJSONToList(LockableResource.class, json.get("resources"));
            for (LockableResource r : newResouces) {
                LockableResource old = this.fromName(r.getName());
                if (old == null) continue;
                r.setBuild(old.getBuild());
                r.setQueued(r.getQueueItemId(), r.getQueueItemProject());
            }
            this.resources = newResouces;
            this.save();
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public synchronized List<LockableResource> checkResourcesAvailability(LockableResourcesStruct requiredResources, @Nullable PrintStream logger, @Nullable List<String> lockedResourcesAboutToBeUnlocked) {
        int requiredAmount = 0;
        ArrayList<LockableResource> candidates = new ArrayList<LockableResource>();
        if (requiredResources.label != null && requiredResources.label.isEmpty()) {
            candidates.addAll(requiredResources.required);
        } else {
            candidates.addAll(this.getResourcesWithLabel(requiredResources.label, null));
            if (requiredResources.requiredNumber != null) {
                try {
                    requiredAmount = Integer.parseInt(requiredResources.requiredNumber);
                }
                catch (NumberFormatException e) {
                    requiredAmount = 0;
                }
            }
        }
        if (requiredAmount == 0) {
            requiredAmount = candidates.size();
        }
        ArrayList<LockableResource> selected = new ArrayList<LockableResource>();
        if (lockedResourcesAboutToBeUnlocked != null) {
            for (LockableResource candidate : candidates) {
                if (!lockedResourcesAboutToBeUnlocked.contains(candidate.getName())) continue;
                selected.add(candidate);
            }
            if (selected.size() == 0) {
                return null;
            }
        }
        for (LockableResource rs : candidates) {
            if (selected.size() >= requiredAmount) break;
            if (rs.isReserved() || rs.isLocked()) continue;
            selected.add(rs);
        }
        if (selected.size() < requiredAmount) {
            if (logger != null) {
                logger.println("Found " + selected.size() + " available resource(s). Waiting for correct amount: " + requiredAmount + ".");
            }
            return null;
        }
        return selected;
    }

    public void queueContext(StepContext context, LockableResourcesStruct requiredResources, String resourceDescription) {
        for (QueuedContextStruct entry : this.queuedContexts) {
            if (entry.getContext() != context) continue;
            return;
        }
        this.queuedContexts.add(new QueuedContextStruct(context, requiredResources, resourceDescription));
        this.save();
    }

    public boolean unqueueContext(StepContext context) {
        ListIterator<QueuedContextStruct> iter = this.queuedContexts.listIterator();
        while (iter.hasNext()) {
            if (((QueuedContextStruct)iter.next()).getContext() != context) continue;
            iter.remove();
            this.save();
            return true;
        }
        return false;
    }

    public static LockableResourcesManager get() {
        return (LockableResourcesManager)Jenkins.getInstance().getDescriptorOrDie(LockableResourcesManager.class);
    }
}

