/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import com.google.inject.Inject;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockStep;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class LockStepExecution
extends AbstractStepExecutionImpl {
    @Inject(optional=true)
    private LockStep step;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient TaskListener listener;
    private static final Logger LOGGER = Logger.getLogger(LockStepExecution.class.getName());
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        this.step.validate();
        this.listener.getLogger().println("Trying to acquire lock on [" + this.step + "]");
        ArrayList<String> resources = new ArrayList<String>();
        if (this.step.resource != null) {
            if (LockableResourcesManager.get().createResource(this.step.resource)) {
                this.listener.getLogger().println("Resource [" + this.step + "] did not exist. Created.");
            }
            resources.add(this.step.resource);
        }
        LockableResourcesStruct resourceHolder = new LockableResourcesStruct(resources, this.step.label, this.step.quantity);
        List<LockableResource> available = LockableResourcesManager.get().checkResourcesAvailability(resourceHolder, this.listener.getLogger(), null);
        if (available == null || !LockableResourcesManager.get().lock(available, this.run, this.getContext(), this.step.toString(), this.step.inversePrecedence)) {
            this.listener.getLogger().println("[" + this.step + "] is locked, waiting...");
            LockableResourcesManager.get().queueContext(this.getContext(), resourceHolder, this.step.toString());
        }
        return false;
    }

    public static void proceed(List<String> resourcenames, StepContext context, String resourceDescription, boolean inversePrecedence) {
        Run r = null;
        try {
            r = (Run)context.get(Run.class);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock acquired on [" + resourceDescription + "]");
        }
        catch (Exception e) {
            context.onFailure((Throwable)e);
            return;
        }
        LOGGER.finest("Lock acquired on [" + resourceDescription + "] by " + r.getExternalizableId());
        context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(resourcenames, resourceDescription, inversePrecedence)).withDisplayName(null).start();
    }

    public void stop(Throwable cause) throws Exception {
        boolean cleaned = LockableResourcesManager.get().unqueueContext(this.getContext());
        if (!cleaned) {
            LOGGER.log(Level.WARNING, "Cannot remove context from lockable resource witing list. The context is not in the waiting list.");
        }
        this.getContext().onFailure(cause);
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private final List<String> resourceNames;
        private final String resourceDescription;
        private final boolean inversePrecedence;
        private static final long serialVersionUID = 1L;

        Callback(List<String> resourceNames, String resourceDescription, boolean inversePrecedence) {
            this.resourceNames = resourceNames;
            this.resourceDescription = resourceDescription;
            this.inversePrecedence = inversePrecedence;
        }

        protected void finished(StepContext context) throws Exception {
            LockableResourcesManager.get().unlockNames(this.resourceNames, (Run)context.get(Run.class), this.inversePrecedence);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock released on resource [" + this.resourceDescription + "]");
            LOGGER.finest("Lock released on [" + this.resourceDescription + "]");
        }
    }
}

