/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class QueuedContextStruct
implements Serializable {
    private StepContext context;
    private List<LockableResourcesStruct> lockableResourcesStruct;
    private String resourceDescription;
    private String variableName;
    private int priority = 0;
    public transient List<String> candidates = null;
    private static final Logger LOGGER = Logger.getLogger(QueuedContextStruct.class.getName());
    private String id = null;
    private static final long serialVersionUID = 1L;

    @Restricted(value={NoExternalUse.class})
    public QueuedContextStruct(StepContext context, List<LockableResourcesStruct> lockableResourcesStruct, String resourceDescription, String variableName, int priority) {
        this.context = context;
        this.lockableResourcesStruct = lockableResourcesStruct;
        this.resourceDescription = resourceDescription;
        this.variableName = variableName;
        this.priority = priority;
        this.id = UUID.randomUUID().toString();
    }

    @Restricted(value={NoExternalUse.class})
    public int compare(QueuedContextStruct other) {
        if (this.priority > other.getPriority()) {
            return -1;
        }
        if (this.priority == other.getPriority()) {
            return 0;
        }
        return 1;
    }

    @Restricted(value={NoExternalUse.class})
    public int getPriority() {
        return this.priority;
    }

    @Restricted(value={NoExternalUse.class})
    public String getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        return this.id;
    }

    @Restricted(value={NoExternalUse.class})
    public StepContext getContext() {
        return this.context;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public Run<?, ?> getBuild() {
        try {
            if (this.getContext() == null) {
                return null;
            }
            return (Run)this.getContext().get(Run.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot get the build object from the context to proceed with lock. The build probably does not exists (deleted?)", e);
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isValid() {
        Run<?, ?> run = this.getBuild();
        if (run == null || !run.isBuilding()) {
            LOGGER.warning("The queue " + String.valueOf(this) + " will be removed, because the build does not exists");
            return false;
        }
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public List<LockableResourcesStruct> getResources() {
        return this.lockableResourcesStruct;
    }

    @Restricted(value={NoExternalUse.class})
    public String getResourceDescription() {
        return this.resourceDescription;
    }

    @Restricted(value={NoExternalUse.class})
    public String getVariableName() {
        return this.variableName;
    }

    @Restricted(value={NoExternalUse.class})
    public String toString() {
        return "build: " + String.valueOf(this.getBuild()) + " resources: " + this.getResourceDescription() + " priority: " + this.priority + " id: " + this.getId();
    }

    @Restricted(value={NoExternalUse.class})
    public PrintStream getLogger() {
        PrintStream logger = null;
        try {
            TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
            if (taskListener != null) {
                logger = taskListener.getLogger();
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.FINE, "Could not get logger for next context: " + String.valueOf(e), e);
        }
        return logger;
    }
}

