/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.Messages;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkins.plugins.lockableresources.ResourceSelectStrategy;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LockStepResource
extends AbstractDescribableImpl<LockStepResource>
implements Serializable {
    @CheckForNull
    public String resource = null;
    @CheckForNull
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String label = null;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public int quantity = 0;
    private static final long serialVersionUID = 1L;

    LockStepResource(@Nullable String resource, @Nullable String label, int quantity) {
        this.resource = resource;
        this.label = label;
        this.quantity = quantity;
    }

    @DataBoundConstructor
    public LockStepResource(@Nullable String resource) {
        if (resource != null && !resource.isEmpty()) {
            this.resource = resource;
        }
    }

    @DataBoundSetter
    public void setLabel(String label) {
        if (label != null && !label.isEmpty()) {
            this.label = label;
        }
    }

    @DataBoundSetter
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String toString() {
        return LockStepResource.toString(this.resource, this.label, this.quantity);
    }

    public static String toString(String resource, String label, int quantity) {
        if (label != null) {
            if (quantity > 0) {
                return "Label: " + label + ", Quantity: " + quantity;
            }
            return "Label: " + label;
        }
        if (resource != null) {
            return "Resource: " + resource;
        }
        return "[no resource/label specified - probably a bug]";
    }

    public void validate() {
        LockStepResource.validate(this.resource, this.label, null, false, 0, false);
    }

    public static void validate(String resource, String label, String resourceSelectStrategy, List<LockStepResource> extra, int priority, boolean inversePrecedence) {
        LockStepResource.validate(resource, label, resourceSelectStrategy, extra != null, priority, inversePrecedence);
        if (extra != null) {
            for (LockStepResource e : extra) {
                e.validate();
            }
        }
    }

    public static void validate(String resource, String label, String resourceSelectStrategy, boolean hasExtra, int priority, boolean inversePrecedence) {
        if (!hasExtra && label == null && resource == null) {
            throw new IllegalArgumentException(Messages.error_labelOrNameMustBeSpecified());
        }
        if (priority != 0 && inversePrecedence) {
            throw new IllegalArgumentException(Messages.error_inversePrecedenceAndPriorityAreSet());
        }
        if (label != null && !label.isEmpty() && resource != null && !resource.isEmpty()) {
            throw new IllegalArgumentException(Messages.error_labelAndNameSpecified());
        }
        if (label != null && !LockableResourcesManager.get().isValidLabel(label).booleanValue()) {
            throw new IllegalArgumentException(Messages.error_labelDoesNotExist(label));
        }
        if (resourceSelectStrategy != null) {
            try {
                ResourceSelectStrategy.valueOf(resourceSelectStrategy.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(Messages.error_invalidResourceSelectionStrategy(resourceSelectStrategy, Arrays.stream(ResourceSelectStrategy.values()).map(Enum::toString).map(strategy -> strategy.toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(", "))));
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LockStepResource> {
        @NonNull
        public String getDisplayName() {
            return Messages.LockStepResource_displayName();
        }

        @RequirePOST
        public AutoCompletionCandidates doAutoCompleteResource(@QueryParameter String value, @AncestorInPath Item item) {
            return RequiredResourcesProperty.DescriptorImpl.doAutoCompleteResourceNames(value, item);
        }

        @RequirePOST
        public static FormValidation doCheckLabel(@QueryParameter String value, @QueryParameter String resource, @AncestorInPath Item item) {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            String resourceLabel = Util.fixEmpty((String)value);
            String resourceName = Util.fixEmpty((String)resource);
            if (resourceLabel != null && resourceName != null) {
                return FormValidation.error((String)Messages.error_labelAndNameSpecified());
            }
            if (resourceLabel == null && resourceName == null) {
                return FormValidation.error((String)Messages.error_labelOrNameMustBeSpecified());
            }
            if (resourceLabel != null && !LockableResourcesManager.get().isValidLabel(resourceLabel).booleanValue()) {
                return FormValidation.error((String)Messages.error_labelDoesNotExist(resourceLabel));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public static FormValidation doCheckResource(@QueryParameter String value, @QueryParameter String label, @AncestorInPath Item item) {
            return DescriptorImpl.doCheckLabel(label, value, item);
        }
    }
}

