/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkins.plugins.lockableresources.LockStep;
import org.jenkins.plugins.lockableresources.LockStepResource;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourceProperty;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.ResourceSelectStrategy;
import org.jenkins.plugins.lockableresources.actions.LockedResourcesBuildAction;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;

public class LockStepExecution
extends AbstractStepExecutionImpl
implements Serializable {
    private static final long serialVersionUID = 1391734561272059623L;
    private static final Logger LOGGER = Logger.getLogger(LockStepExecution.class.getName());
    private final LockStep step;

    public LockStepExecution(LockStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() throws Exception {
        ResourceSelectStrategy resourceSelectStrategy = ResourceSelectStrategy.valueOf(this.step.resourceSelectStrategy.toUpperCase(Locale.ENGLISH));
        PrintStream logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
        Run run = (Run)this.getContext().get(Run.class);
        ArrayList<LockableResourcesStruct> resourceHolderList = new ArrayList<LockableResourcesStruct>();
        List<LockableResource> available = null;
        LinkedHashMap<String, List<LockableResourceProperty>> lockedResources = new LinkedHashMap<String, List<LockableResourceProperty>>();
        LockableResourcesManager lrm = LockableResourcesManager.get();
        Object object = LockableResourcesManager.syncResources;
        synchronized (object) {
            boolean lockFailed;
            this.step.validate();
            LockableResourcesManager.printLogs("Trying to acquire lock on [" + String.valueOf(this.step) + "]", Level.FINE, LOGGER, logger);
            ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new PauseAction("Lock"));
            ArrayList<String> resourceNames = new ArrayList<String>();
            for (LockStepResource resource : this.step.getResources()) {
                ArrayList<String> resources = new ArrayList<String>();
                if (resource.resource != null) {
                    if (lrm.createResource(resource.resource)) {
                        LockableResourcesManager.printLogs("Resource [" + resource.resource + "] did not exist. Created.", Level.FINE, LOGGER, logger);
                    }
                    resources.add(resource.resource);
                    resourceNames.addAll(resources);
                } else {
                    resourceNames.add("N/A");
                }
                resourceHolderList.add(new LockableResourcesStruct(resources, resource.label, resource.quantity));
            }
            LockedResourcesBuildAction.addLog(run, resourceNames, "try", this.step.toString());
            available = lrm.getAvailableResources(resourceHolderList, logger, resourceSelectStrategy);
            if (available == null || available.isEmpty()) {
                LOGGER.fine("No available resources: " + String.valueOf(available));
                this.onLockFailed(logger, resourceHolderList);
                return false;
            }
            boolean bl = lockFailed = !lrm.lock(available, run);
            if (lockFailed) {
                LOGGER.warning("Internal program error: Can not lock resources: " + String.valueOf(available));
                this.onLockFailed(logger, resourceHolderList);
                return true;
            }
            for (LockableResource resource : available) {
                lockedResources.put(resource.getName(), resource.getProperties());
            }
            LockStepExecution.proceed(lockedResources, this.getContext(), this.step.toString(), this.step.variable);
        }
        return false;
    }

    private void onLockFailed(PrintStream logger, List<LockableResourcesStruct> resourceHolderList) {
        if (this.step.skipIfLocked) {
            this.printBlockCause(logger, resourceHolderList);
            LockableResourcesManager.printLogs("[" + String.valueOf(this.step) + "] is not free, skipping execution ...", Level.FINE, LOGGER, logger);
            this.getContext().onSuccess(null);
        } else {
            this.printBlockCause(logger, resourceHolderList);
            LockableResourcesManager.printLogs("[" + String.valueOf(this.step) + "] is not free, waiting for execution ...", Level.FINE, LOGGER, logger);
            LockableResourcesManager lrm = LockableResourcesManager.get();
            lrm.queueContext(this.getContext(), resourceHolderList, this.step.toString(), this.step.variable, this.step.inversePrecedence, this.step.priority);
        }
    }

    private void printBlockCause(PrintStream logger, List<LockableResourcesStruct> resourceHolderList) {
        LockableResource resource;
        LockableResourcesManager lrm = LockableResourcesManager.get();
        LockableResource lockableResource = resource = this.step.resource != null ? lrm.fromName(this.step.resource) : null;
        if (resource != null) {
            String logMessage = resource.getLockCauseDetail();
            if (logMessage != null && !logMessage.isEmpty()) {
                LockableResourcesManager.printLogs(logMessage, Level.FINE, LOGGER, logger);
            }
        } else {
            lrm.getAvailableResources(resourceHolderList, logger, null);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="not sure which exceptions might be catch.")
    public static void proceed(final LinkedHashMap<String, List<LockableResourceProperty>> lockedResources, StepContext context, String resourceDescription, final String variable) {
        Run build;
        FlowNode node = null;
        PrintStream logger = null;
        try {
            build = (Run)context.get(Run.class);
            node = (FlowNode)context.get(FlowNode.class);
            logger = ((TaskListener)context.get(TaskListener.class)).getLogger();
            LockableResourcesManager.printLogs("Lock acquired on [" + resourceDescription + "]", Level.FINE, LOGGER, logger);
        }
        catch (Exception e) {
            context.onFailure((Throwable)e);
            return;
        }
        try {
            ArrayList<String> resourceNames = new ArrayList<String>(lockedResources.keySet());
            final String resourceNamesAsString = String.join((CharSequence)",", lockedResources.keySet());
            LockedResourcesBuildAction.addLog(build, resourceNames, "acquired", resourceDescription);
            PauseAction.endCurrentPause((FlowNode)node);
            BodyInvoker bodyInvoker = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(resourceNames, resourceDescription));
            if (variable != null && !variable.isEmpty()) {
                bodyInvoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)new EnvironmentExpander(){
                    private static final long serialVersionUID = -3431466225193397896L;

                    public void expand(@NonNull EnvVars env) {
                        LinkedHashMap<Object, String> variables = new LinkedHashMap<Object, String>();
                        variables.put(variable, resourceNamesAsString);
                        int index = 0;
                        for (Map.Entry lockResourceEntry : lockedResources.entrySet()) {
                            String lockEnvName = variable + index;
                            variables.put(lockEnvName, (String)lockResourceEntry.getKey());
                            for (LockableResourceProperty lockProperty : (List)lockResourceEntry.getValue()) {
                                String propEnvName = lockEnvName + "_" + lockProperty.getName();
                                variables.put(propEnvName, lockProperty.getValue());
                            }
                            ++index;
                        }
                        LOGGER.finest("Setting " + variables.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ")) + " for the duration of the block");
                        env.overrideAll(variables);
                    }
                }));
            }
            bodyInvoker.start();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warning("proceed done with failure " + resourceDescription);
            throw new RuntimeException(e);
        }
    }

    public void stop(@NonNull Throwable cause) {
        boolean cleaned = LockableResourcesManager.get().unqueueContext(this.getContext());
        if (!cleaned) {
            LOGGER.log(Level.WARNING, "Cannot remove context from lockable resource waiting list. The context is not in the waiting list.");
        }
        this.getContext().onFailure(cause);
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = -2024890670461847666L;
        private final List<String> resourceNames;
        private final String resourceDescription;

        Callback(List<String> resourceNames, String resourceDescription) {
            this.resourceNames = resourceNames;
            this.resourceDescription = resourceDescription;
        }

        protected void finished(StepContext context) throws Exception {
            Run build = (Run)context.get(Run.class);
            LockedResourcesBuildAction.addLog(build, this.resourceNames, "released", this.resourceDescription);
            LockableResourcesManager.get().unlockNames(this.resourceNames, build);
            LockableResourcesManager.printLogs("Lock released on resource [" + this.resourceDescription + "]", Level.FINE, LOGGER, ((TaskListener)context.get(TaskListener.class)).getLogger());
        }
    }
}

