/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Api;
import hudson.model.RootAction;
import hudson.security.AccessDeniedException3;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.Messages;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.QueuedContextStruct;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@ExportedBean
public class LockableResourcesRootAction
implements RootAction {
    public static final PermissionGroup PERMISSIONS_GROUP = new PermissionGroup(LockableResourcesManager.class, Messages._LockableResourcesRootAction_PermissionGroup());
    public static final Permission UNLOCK = new Permission(PERMISSIONS_GROUP, Messages.LockableResourcesRootAction_UnlockPermission(), Messages._LockableResourcesRootAction_UnlockPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission RESERVE = new Permission(PERMISSIONS_GROUP, Messages.LockableResourcesRootAction_ReservePermission(), Messages._LockableResourcesRootAction_ReservePermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission STEAL = new Permission(PERMISSIONS_GROUP, Messages.LockableResourcesRootAction_StealPermission(), Messages._LockableResourcesRootAction_StealPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission VIEW = new Permission(PERMISSIONS_GROUP, Messages.LockableResourcesRootAction_ViewPermission(), Messages._LockableResourcesRootAction_ViewPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final String ICON = "symbol-lock-closed";

    public String getIconFileName() {
        return Jenkins.get().hasPermission(VIEW) ? ICON : null;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @CheckForNull
    public String getUserName() {
        return LockableResource.getUserName();
    }

    public String getDisplayName() {
        return Messages.LockableResourcesRootAction_PermissionGroup();
    }

    public String getUrlName() {
        return Jenkins.get().hasPermission(VIEW) ? "lockable-resources" : "";
    }

    @Exported
    public List<LockableResource> getResources() {
        return LockableResourcesManager.get().getResources();
    }

    public LockableResource getResource(String resourceName) {
        return LockableResourcesManager.get().fromName(resourceName);
    }

    public int getFreeResourceAmount(String label) {
        return LockableResourcesManager.get().getFreeResourceAmount(label);
    }

    @Restricted(value={NoExternalUse.class})
    public int getFreeResourcePercentage(String label) {
        int allCount = this.getAssignedResourceAmount(label);
        if (allCount == 0) {
            return allCount;
        }
        return (int)((double)this.getFreeResourceAmount(label) / (double)allCount * 100.0);
    }

    public Set<String> getAllLabels() {
        return LockableResourcesManager.get().getAllLabels();
    }

    public int getNumberOfAllLabels() {
        return LockableResourcesManager.get().getAllLabels().size();
    }

    @Restricted(value={NoExternalUse.class})
    public int getAssignedResourceAmount(String label) {
        return LockableResourcesManager.get().getResourcesWithLabel(label, null).size();
    }

    @Restricted(value={NoExternalUse.class})
    public List<QueuedContextStruct> getCurrentQueuedContext() {
        return LockableResourcesManager.get().getCurrentQueuedContext();
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public LockableResourcesStruct getOldestQueue() {
        LockableResourcesStruct oldest = null;
        for (QueuedContextStruct context : this.getCurrentQueuedContext()) {
            for (LockableResourcesStruct resourceStruct : context.getResources()) {
                if (resourceStruct.queuedAt == 0L || oldest != null && oldest.queuedAt <= resourceStruct.queuedAt) continue;
                oldest = resourceStruct;
            }
        }
        return oldest;
    }

    @RequirePOST
    public void doUnlock(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(UNLOCK);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        LockableResourcesManager.get().unlock(resources, null);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doReserve(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(RESERVE);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        String userName = this.getUserName();
        if (userName != null && !LockableResourcesManager.get().reserve(resources, userName)) {
            rsp.sendError(423, Messages.error_resourceAlreadyLocked(LockableResourcesManager.getResourcesNames(resources)));
            return;
        }
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doSteal(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(STEAL);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        String userName = this.getUserName();
        if (userName != null) {
            LockableResourcesManager.get().steal(resources, userName);
        }
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doReassign(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(STEAL);
        String userName = this.getUserName();
        if (userName == null) {
            throw new AccessDeniedException3(Jenkins.getAuthentication2(), STEAL);
        }
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        for (LockableResource resource : resources) {
            if (!userName.equals(resource.getReservedBy())) continue;
            return;
        }
        LockableResourcesManager.get().reassign(resources, userName);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doUnreserve(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(RESERVE);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        String userName = this.getUserName();
        for (LockableResource resource : resources) {
            if (userName != null && userName.equals(resource.getReservedBy()) || Jenkins.get().hasPermission(Jenkins.ADMINISTER)) continue;
            throw new AccessDeniedException3(Jenkins.getAuthentication2(), RESERVE);
        }
        LockableResourcesManager.get().unreserve(resources);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doReset(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(UNLOCK);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        LockableResourcesManager.get().reset(resources);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doSaveNote(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        LockableResource resource;
        Jenkins.get().checkPermission(RESERVE);
        String resourceName = req.getParameter("resource");
        if (resourceName == null) {
            resourceName = req.getParameter("resourceName");
        }
        if ((resource = this.getResource(resourceName)) == null) {
            rsp.sendError(404, Messages.error_resourceDoesNotExist(resourceName));
        } else {
            String resourceNote = req.getParameter("note");
            if (resourceNote == null) {
                resourceNote = req.getParameter("resourceNote");
            }
            resource.setNote(resourceNote);
            LockableResourcesManager.get().save();
            rsp.forwardToPreviousPage(req);
        }
    }

    private List<LockableResource> getResourcesFromRequest(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String name = req.getParameter("resource");
        LockableResource r = LockableResourcesManager.get().fromName(name);
        if (r == null) {
            rsp.sendError(404, Messages.error_resourceDoesNotExist(name));
            return null;
        }
        ArrayList<LockableResource> resources = new ArrayList<LockableResource>();
        resources.add(r);
        return resources;
    }
}

