/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.actions;

import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResource;

public class LockedResourcesBuildAction
implements Action {
    private final List<ResourcePOJO> lockedResources;

    public LockedResourcesBuildAction(List<ResourcePOJO> lockedResources) {
        this.lockedResources = lockedResources;
    }

    public List<ResourcePOJO> getLockedResources() {
        return this.lockedResources;
    }

    public String getIconFileName() {
        return "symbol-lock-closed";
    }

    public String getDisplayName() {
        return "Locked Resources";
    }

    public String getUrlName() {
        return "locked-resources";
    }

    public static LockedResourcesBuildAction fromResources(Collection<LockableResource> resources) {
        ArrayList<ResourcePOJO> resPojos = new ArrayList<ResourcePOJO>();
        for (LockableResource r : resources) {
            resPojos.add(new ResourcePOJO(r));
        }
        return new LockedResourcesBuildAction(resPojos);
    }

    public static class ResourcePOJO {
        private String name;
        private String description;

        public ResourcePOJO(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public ResourcePOJO(LockableResource r) {
            this.name = r.getName();
            this.description = r.getDescription();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

