/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import java.util.ArrayList;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;

public class LockableResourcesStruct {
    public List<LockableResource> required = new ArrayList<LockableResource>();
    public String label;
    public String requiredVar;
    public String requiredNumber;

    public LockableResourcesStruct(RequiredResourcesProperty property) {
        for (String name : property.getResources()) {
            LockableResource r = LockableResourcesManager.get().fromName(name);
            if (r == null) continue;
            this.required.add(r);
        }
        this.label = property.getLabelName();
        if (this.label == null) {
            this.label = "";
        }
        this.requiredVar = property.getResourceNamesVar();
        if (this.requiredVar != null && this.requiredVar.equals("")) {
            this.requiredVar = null;
        }
        this.requiredNumber = property.getResourceNumber();
        if (this.requiredNumber != null && (this.requiredNumber.equals("") || this.requiredNumber.trim().equals("0"))) {
            this.requiredNumber = null;
        }
    }

    public String toString() {
        return "Required resources: " + this.required + ", Required label: " + this.label + ", Variable name: " + this.requiredVar + ", Number of resources: " + this.requiredNumber;
    }
}

