/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.StringParameterValue;
import hudson.model.queue.QueueSorter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class LockPrioritySorter
extends QueueSorter {
    static final PriorityComparator COMPARATOR = new PriorityComparator();

    public void sortBuildableItems(List<Queue.BuildableItem> buildables) {
        Collections.sort(buildables, COMPARATOR);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PriorityComparator
    implements Comparator<Queue.BuildableItem> {
        PriorityComparator() {
        }

        @Override
        public int compare(Queue.BuildableItem o1, Queue.BuildableItem o2) {
            return this.getPriority(o1) - this.getPriority(o2);
        }

        public int getPriority(Queue.BuildableItem item) {
            String paramName = LockableResourcesManager.get().getPriorityParameterName();
            int defaultPriority = LockableResourcesManager.get().getDefaultPriority();
            for (Action action : item.getActions()) {
                if (!(action instanceof ParametersAction)) continue;
                ParametersAction pa = (ParametersAction)action;
                for (ParameterValue p : pa.getParameters()) {
                    if (!(p instanceof StringParameterValue) || !p.getName().equals(paramName)) continue;
                    String value = ((StringParameterValue)p).value;
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        return defaultPriority;
                    }
                }
            }
            return defaultPriority;
        }
    }
}

