/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import hudson.Extension;
import hudson.Util;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredResourcesProperty
extends JobProperty<Job<?, ?>> {
    private final String resourceNames;
    private final String resourceNamesVar;
    private final String resourceNumber;
    private final String labelName;

    @DataBoundConstructor
    public RequiredResourcesProperty(String resourceNames, String resourceNamesVar, String resourceNumber, String labelName) {
        this.resourceNames = resourceNames;
        this.resourceNamesVar = resourceNamesVar;
        this.resourceNumber = resourceNumber;
        this.labelName = labelName;
    }

    public String[] getResources() {
        String names = Util.fixEmptyAndTrim((String)this.resourceNames);
        if (names != null) {
            return names.split("\\s+");
        }
        return new String[0];
    }

    public String getResourceNames() {
        return this.resourceNames;
    }

    public String getResourceNamesVar() {
        return this.resourceNamesVar;
    }

    public String getResourceNumber() {
        return this.resourceNumber;
    }

    public String getLabelName() {
        return this.labelName;
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "Required Lockable Resources";
        }

        public RequiredResourcesProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.isNullObject()) {
                return null;
            }
            JSONObject json = formData.getJSONObject("required-lockable-resources");
            if (json.isNullObject()) {
                return null;
            }
            String resourceNames = Util.fixEmptyAndTrim((String)json.getString("resourceNames"));
            String resourceNamesVar = Util.fixEmptyAndTrim((String)json.getString("resourceNamesVar"));
            String resourceNumber = Util.fixEmptyAndTrim((String)json.getString("resourceNumber"));
            String labelName = Util.fixEmptyAndTrim((String)json.getString("labelName"));
            if (resourceNames == null && labelName == null) {
                return null;
            }
            return new RequiredResourcesProperty(resourceNames, resourceNamesVar, resourceNumber, labelName);
        }

        public FormValidation doCheckResourceNames(@QueryParameter String value) {
            String names = Util.fixEmptyAndTrim((String)value);
            if (names == null) {
                return FormValidation.ok();
            }
            ArrayList<String> wrongNames = new ArrayList<String>();
            for (String name : names.split("\\s+")) {
                boolean found = false;
                for (LockableResource r : LockableResourcesManager.get().getResources()) {
                    if (!r.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                wrongNames.add(name);
            }
            if (wrongNames.isEmpty()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("The following resources do not exist: " + wrongNames));
        }

        public FormValidation doCheckLabelName(@QueryParameter String value, @QueryParameter String resourceNames) {
            String label = Util.fixEmptyAndTrim((String)value);
            String names = Util.fixEmptyAndTrim((String)resourceNames);
            if (label == null) {
                return FormValidation.ok();
            }
            if (names != null) {
                return FormValidation.error((String)"Only label or resources can be defined, not both.");
            }
            if (LockableResourcesManager.get().isValidLabel(label).booleanValue()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("The label does not exist: " + label));
        }

        public FormValidation doCheckResourceNumber(@QueryParameter String value, @QueryParameter String resourceNames, @QueryParameter String labelName) {
            int numAsInt;
            String number = Util.fixEmptyAndTrim((String)value);
            String names = Util.fixEmptyAndTrim((String)resourceNames);
            String label = Util.fixEmptyAndTrim((String)labelName);
            if (number == null || number.equals("") || number.trim().equals("0")) {
                return FormValidation.ok();
            }
            try {
                numAsInt = Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Could not parse the given value as integer.");
            }
            int numResources = 0;
            if (names != null) {
                numResources = names.split("\\s+").length;
            } else if (label != null) {
                numResources = LockableResourcesManager.get().getResourcesWithLabel(label).size();
            }
            if (numResources < numAsInt) {
                return FormValidation.error((String)String.format("Given amount %d is greater than amount of resources: %d.", numAsInt, numResources));
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteLabelName(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            value = Util.fixEmptyAndTrim((String)value);
            for (String l : LockableResourcesManager.get().getAllLabels()) {
                if (value == null || !l.startsWith(value)) continue;
                c.add(l);
            }
            return c;
        }

        public AutoCompletionCandidates doAutoCompleteResourceNames(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            if ((value = Util.fixEmptyAndTrim((String)value)) != null) {
                for (LockableResource r : LockableResourcesManager.get().getResources()) {
                    if (!r.getName().startsWith(value)) continue;
                    c.add(r.getName());
                }
            }
            return c;
        }
    }
}

