/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Queue;
import java.util.Arrays;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockableResource
extends AbstractDescribableImpl<LockableResource> {
    public static final int NOT_QUEUED = 0;
    private static final int QUEUE_TIMEOUT = 60;
    private final String name;
    private final String description;
    private final String labels;
    private String reservedBy;
    private transient int queueItemId = 0;
    private transient String queueItemProject = null;
    private transient AbstractBuild<?, ?> build = null;
    private transient long queuingStarted = 0L;

    @DataBoundConstructor
    public LockableResource(String name, String description, String labels, String reservedBy) {
        this.name = name;
        this.description = description;
        this.labels = labels;
        this.reservedBy = Util.fixEmptyAndTrim((String)reservedBy);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabels() {
        return this.labels;
    }

    public Boolean isValidLabel(String candidate) {
        return Arrays.asList(this.labels.split("\\s+")).contains(candidate);
    }

    public String getReservedBy() {
        return this.reservedBy;
    }

    public boolean isReserved() {
        return this.reservedBy != null;
    }

    public boolean isQueued() {
        this.validateQueuingTimeout();
        return this.queueItemId != 0;
    }

    public boolean isQueued(int taskId) {
        this.validateQueuingTimeout();
        return this.queueItemId != 0 && this.queueItemId != taskId;
    }

    public boolean isQueuedByTask(int taskId) {
        this.validateQueuingTimeout();
        return this.queueItemId == taskId;
    }

    public void unqueue() {
        this.queueItemId = 0;
        this.queueItemProject = null;
        this.queuingStarted = 0L;
    }

    public boolean isLocked() {
        return this.build != null;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public void setBuild(AbstractBuild<?, ?> lockedBy) {
        this.build = lockedBy;
    }

    public Queue.Task getTask() {
        Queue.Item item = Queue.getInstance().getItem(this.queueItemId);
        if (item != null) {
            return item.task;
        }
        return null;
    }

    public int getQueueItemId() {
        this.validateQueuingTimeout();
        return this.queueItemId;
    }

    public String getQueueItemProject() {
        this.validateQueuingTimeout();
        return this.queueItemProject;
    }

    public void setQueued(int queueItemId) {
        this.queueItemId = queueItemId;
        this.queuingStarted = System.currentTimeMillis() / 1000L;
    }

    public void setQueued(int queueItemId, String queueProjectName) {
        this.setQueued(queueItemId);
        this.queueItemProject = queueProjectName;
    }

    private void validateQueuingTimeout() {
        long now;
        if (this.queuingStarted > 0L && (now = System.currentTimeMillis() / 1000L) - this.queuingStarted > 60L) {
            this.unqueue();
        }
    }

    public void setReservedBy(String userName) {
        this.reservedBy = userName;
    }

    public void unReserve() {
        this.reservedBy = null;
    }

    public void reset() {
        this.unReserve();
        this.unqueue();
        this.setBuild(null);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LockableResource other = (LockableResource)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<LockableResource> {
        public String getDisplayName() {
            return "Resource";
        }
    }
}

