/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.actions;

import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.security.AccessDeniedException2;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.Messages;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class LockableResourcesRootAction
implements RootAction {
    public static final PermissionGroup PERMISSIONS_GROUP = new PermissionGroup(LockableResourcesManager.class, Messages._PermissionGroup());
    public static final Permission UNLOCK = new Permission(PERMISSIONS_GROUP, Messages.UnlockPermission(), Messages._UnlockPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission RESERVE = new Permission(PERMISSIONS_GROUP, Messages.ReservePermission(), Messages._ReservePermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final String ICON = "/plugin/lockable-resources/img/device-24x24.png";

    public String getIconFileName() {
        if (User.current() != null) {
            return ICON;
        }
        return null;
    }

    public String getUserName() {
        if (User.current() != null) {
            return User.current().getFullName();
        }
        return null;
    }

    public String getDisplayName() {
        return "Lockable Resources";
    }

    public String getUrlName() {
        return "lockable-resources";
    }

    public List<LockableResource> getResources() {
        return LockableResourcesManager.get().getResources();
    }

    public void doUnlock(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(UNLOCK);
        String name = req.getParameter("resource");
        LockableResource r = LockableResourcesManager.get().fromName(name);
        if (r == null) {
            rsp.sendError(404, "Resource not found " + name);
            return;
        }
        ArrayList<LockableResource> resources = new ArrayList<LockableResource>();
        resources.add(r);
        LockableResourcesManager.get().unlock(resources, null);
        rsp.forwardToPreviousPage(req);
    }

    public void doReserve(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(RESERVE);
        String name = req.getParameter("resource");
        LockableResource r = LockableResourcesManager.get().fromName(name);
        if (r == null) {
            rsp.sendError(404, "Resource not found " + name);
            return;
        }
        ArrayList<LockableResource> resources = new ArrayList<LockableResource>();
        resources.add(r);
        String userName = this.getUserName();
        if (userName != null) {
            LockableResourcesManager.get().reserve(resources, userName);
        }
        rsp.forwardToPreviousPage(req);
    }

    public void doUnreserve(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(RESERVE);
        String name = req.getParameter("resource");
        LockableResource r = LockableResourcesManager.get().fromName(name);
        if (r == null) {
            rsp.sendError(404, "Resource not found " + name);
            return;
        }
        String userName = this.getUserName();
        if (!(userName != null && userName.equals(r.getReservedBy()) || Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER))) {
            throw new AccessDeniedException2(Jenkins.getAuthentication(), RESERVE);
        }
        ArrayList<LockableResource> resources = new ArrayList<LockableResource>();
        resources.add(r);
        LockableResourcesManager.get().unreserve(resources);
        rsp.forwardToPreviousPage(req);
    }

    public void doReset(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(UNLOCK);
        String name = req.getParameter("resource");
        LockableResource r = LockableResourcesManager.get().fromName(name);
        if (r == null) {
            rsp.sendError(404, "Resource not found " + name);
            return;
        }
        ArrayList<LockableResource> resources = new ArrayList<LockableResource>();
        resources.add(r);
        LockableResourcesManager.get().reset(resources);
        rsp.forwardToPreviousPage(req);
    }
}

