/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.actions;

import hudson.model.Action;
import java.util.ArrayList;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResource;

public class LockedResourcesBuildAction
implements Action {
    private final List<ResourcePOJO> lockedResources;

    public LockedResourcesBuildAction(List<ResourcePOJO> lockedResources) {
        this.lockedResources = lockedResources;
    }

    public List<ResourcePOJO> getLockedResources() {
        return this.lockedResources;
    }

    public String getIconFileName() {
        return "/plugin/lockable-resources/img/device-24x24.png";
    }

    public String getDisplayName() {
        return "Locked Resources";
    }

    public String getUrlName() {
        return "locked-resources";
    }

    public static LockedResourcesBuildAction fromResources(List<LockableResource> resources) {
        ArrayList<ResourcePOJO> resPojos = new ArrayList<ResourcePOJO>();
        for (LockableResource r : resources) {
            resPojos.add(new ResourcePOJO(r));
        }
        return new LockedResourcesBuildAction(resPojos);
    }

    public static class ResourcePOJO {
        public String name;
        public String description;

        public ResourcePOJO(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public ResourcePOJO(LockableResource r) {
            this.name = r.getName();
            this.description = r.getDescription();
        }
    }
}

