/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.xwork.util;

import ognl.MethodFailedException;
import ognl.ObjectMethodAccessor;

import java.util.Map;


/**
 * Allows methods to be executed under normal cirumstances, except when {@link #DENY_METHOD_EXECUTION}
 * is in the action context with a value of true.
 *
 * @author Patrick Lightbody
 */
public class XWorkMethodAccessor extends ObjectMethodAccessor {

    public static final String DENY_METHOD_EXECUTION = "xwork.MethodAccessor.denyMethodExecution";

    public Object callMethod(Map context, Object object, String string, Object[] objects) throws MethodFailedException {
        if (Boolean.TRUE.equals(context.get(DENY_METHOD_EXECUTION))) {
            return null;
        }
        return super.callMethod(context, object, string, objects);
    }

    public Object callStaticMethod(Map context, Class aClass, String string, Object[] objects) throws MethodFailedException {
        if (Boolean.TRUE.equals(context.get(DENY_METHOD_EXECUTION))) {
            return null;
        }
        return super.callStaticMethod(context, aClass, string, objects);
    }
}
