/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.xwork.config;

import com.opensymphony.xwork.config.entities.PackageConfig;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import static java.util.Collections.emptySet;


/**
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: May 6, 2003
 * Time: 3:13:55 PM
 * To change this template use Options | File Templates.
 */
public interface Configuration {
    //~ Methods ////////////////////////////////////////////////////////////////

    public void rebuildRuntimeConfiguration();

    PackageConfig getPackageConfig(String name);

    Set getPackageConfigNames();

    Map getPackageConfigs();

    /**
     * the current runtime configuration.  currently, if changes have been made to the Configuration since the last
     * time buildRuntimeConfiguration() was called, you'll need to make sure to
     *
     * @return
     */
    RuntimeConfiguration getRuntimeConfiguration();

    void addPackageConfig(String name, PackageConfig packageConfig);

    /**
     * allow the Configuration to clean up any resources that have been used
     */
    void destroy();

    /**
     * @throws ConfigurationException
     */
    void reload() throws ConfigurationException;

    void refreshSecurityConfig();

    void removePackageConfig(String name);

    default void addExcludedClasses(Collection<String> commaDelimitedClasses) {
    }

    default Set<String> getExcludedClasses() {
        return emptySet();
    }

    default void addExcludedPackageNames(Collection<String> commaDelimitedPackageNames) {
    }

    default Set<String> getExcludedPackageNames() {
        return emptySet();
    }

    default void setExcludedPackageExemptClasses(Collection<String> commaDelimitedClasses) {
    }

    default Set<String> getExcludedPackageExemptClasses() {
        return emptySet();
    }

    default void setAllowStaticMethodAccess(boolean allowStaticMethodAccess) {
    }

    default boolean isAllowStaticMethodAccess() {
        return true;
    }

    default void setAllowStaticFieldAccess(boolean allowStaticFieldAccess) {
    }

    default boolean isAllowStaticFieldAccess() {
        return true;
    }

    default void setDisallowProxyMemberAccess(boolean disallowProxyMemberAccess) {
    }

    default boolean isDisallowProxyMemberAccess() {
        return false;
    }

    default void setDisallowDefaultPackageAccess(boolean disallowDefaultPackageAccess) {
    }

    default boolean isDisallowDefaultPackageAccess() {
        return false;
    }

    default void setStaticMemberAllowedClasses(Collection<String> commaDelimitedClasses) {
    }

    default Set<String> getStaticMemberAllowedClasses() { return emptySet(); }

    default void setOgnlExpressionMaxLength(int ognlExpressionMaxLength) {
    }

    default int getOgnlExpressionMaxLength() { return 200; }

    default void addOgnlExcludedNodeTypes(Collection<String> commaDelimitedNodeTypes) {
    }

    /**
     * This ExcludedNodeTypes is a set of node, which we used to exclude node from any expression.
     * this contains node which we didn't allow in expression. like ASTStaticField, ASTCtor, ASTAssign
     */
    default Set<String> getOgnlExcludedNodeTypes() {
        return emptySet();
    }

    default void setEnforceAllowlistEnabled(boolean enabled) {
    }

    default boolean isEnforceAllowlistEnabled() {
        return false;
    }

    default void setAllowlistClasses(Collection<String> commaDelimitedClasses) {
    }

    default Set<String> getAllowlistClasses() {
        return emptySet();
    }

    default void setAllowlistPackageNames(Collection<String> commaDelimitedPackageNames) {
    }

    default Set<String> getAllowlistPackageNames() { return emptySet(); }
}
