/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.DebugPageWriter;
import com.opensymphony.module.sitemesh.filter.NullOutputBuffer;
import com.opensymphony.module.sitemesh.filter.OutputBuffer;
import com.opensymphony.module.sitemesh.filter.PageOutputStream;
import com.opensymphony.module.sitemesh.filter.PageWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class PageResponseWrapper
extends HttpServletResponseWrapper {
    private PageWriter pageWriter = null;
    private PageOutputStream pageOutputStream = null;
    private boolean usingStream = false;
    private boolean usingWriter = false;
    private Config config = null;
    private Page page = null;
    private String contentType = null;
    private String encoding = null;
    private boolean aborted = false;
    private boolean parseablePage = false;
    private long lastModified;
    private boolean debug;
    private HttpServletResponse response = null;

    public PageResponseWrapper(HttpServletResponse response, Config config) throws IOException {
        this(response, config, false);
    }

    public PageResponseWrapper(HttpServletResponse response, Config config, boolean debug) throws IOException {
        super(response);
        this.response = response;
        this.config = config;
        this.debug = debug;
    }

    public void setContentType(String type) {
        int index = -1;
        if (type != null) {
            index = type.lastIndexOf("charset=");
            if (index != -1) {
                this.encoding = type.substring(index + 8).trim();
            }
            this.contentType = (index = type.indexOf(59)) > 0 ? type.substring(0, index) : type;
            super.setContentType(type);
        }
        if (Factory.getInstance(this.config).shouldParsePage(this.contentType)) {
            this.parseablePage = true;
        } else {
            this.getBufferStream().discardBuffer();
            this.parseablePage = false;
        }
    }

    public void setContentLength(int contentLength) {
        if (!this.parseablePage()) {
            super.setContentLength(contentLength);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.parseablePage() && "Last-Modified".equalsIgnoreCase(name)) {
            this.lastModified = value;
        } else {
            super.setDateHeader(name, value);
        }
    }

    public void setStatus(int sc) {
        if (sc == 304) {
            if (!this.parseablePage()) {
                super.setStatus(sc);
            }
        } else {
            super.setStatus(sc);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.getPageOutputStream();
    }

    private PageOutputStream getPageOutputStream() throws IOException {
        if (this.pageOutputStream == null) {
            if (this.usingWriter) {
                throw new IllegalStateException("Cannot call getOutputStream() after getWriter()");
            }
            this.usingStream = true;
            this.pageOutputStream = new PageOutputStream((OutputStream)super.getOutputStream(), this.encoding);
        }
        return this.pageOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.debug) {
            return new DebugPageWriter(this.getPageWriter());
        }
        return this.getPageWriter();
    }

    private PageWriter getPageWriter() throws IOException {
        if (this.pageWriter == null) {
            if (this.usingStream) {
                throw new IllegalStateException("Cannot call getWriter() after getOutputStream()");
            }
            this.usingWriter = true;
            this.pageWriter = new PageWriter(this.response.getWriter());
        }
        return this.pageWriter;
    }

    public void closeWriter() throws IOException {
        if (this.parseablePage()) {
            this.getBufferStream().flush();
        }
    }

    private boolean parseablePage() {
        return this.parseablePage;
    }

    private OutputBuffer getBufferStream() {
        if (this.usingStream) {
            return this.pageOutputStream;
        }
        if (this.usingWriter) {
            return this.pageWriter;
        }
        return NullOutputBuffer.getInstance();
    }

    public boolean isUsingStream() {
        return this.usingStream;
    }

    public boolean isUsingWriter() {
        return this.usingWriter;
    }

    public Page getPage() throws IOException {
        this.getBufferStream().flush();
        Factory factory = Factory.getInstance(this.config);
        if (this.contentType == null || !factory.shouldParsePage(this.contentType)) {
            this.getBufferStream().discardBuffer();
        }
        if (this.aborted || !this.parseablePage()) {
            return null;
        }
        if (this.page == null) {
            PageParser parser = factory.getPageParser(this.contentType);
            return parser.parse(this.getBufferStream().getBuffer());
        }
        return this.page;
    }

    public void sendError(int sc) throws IOException {
        this.aborted = true;
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.aborted = true;
        super.sendError(sc, msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.aborted = true;
        super.sendRedirect(location);
    }
}

