/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.filter.OutputBuffer;
import com.opensymphony.module.sitemesh.util.FastByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import javax.servlet.ServletOutputStream;

public class PageOutputStream
extends ServletOutputStream
implements OutputBuffer {
    private ByteArrayOutputStream buffer = null;
    private OutputStream original = null;
    private OutputStream target = null;
    private String encoding;
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final boolean JDK14 = System.getProperty("java.version").startsWith("1.4");

    public PageOutputStream(OutputStream original, String encoding) {
        this.encoding = encoding;
        this.original = original;
        this.buffer = new FastByteArrayOutputStream();
        this.target = this.buffer;
    }

    public void write(int b) throws IOException {
        this.target.write(b);
    }

    public void discardBuffer() {
        if (this.target == this.buffer) {
            this.target = this.original;
            try {
                this.original.write(this.buffer.toByteArray());
                this.original.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public char[] get14Buffer() {
        String enc = this.encoding;
        if (enc == null) {
            enc = DEFAULT_ENCODING;
        }
        if (!Charset.isSupported(enc)) {
            throw new InternalError("Unsupported encoding " + enc);
        }
        Charset charset = Charset.forName(enc);
        CharsetDecoder cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] ba = this.buffer.toByteArray();
        int en = (int)(cd.maxCharsPerByte() * (float)ba.length);
        char[] ca = new char[en];
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca);
        try {
            CoderResult cr = cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = cd.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (Exception x) {
            throw new Error(x);
        }
        return PageOutputStream.trim(ca, cb.position());
    }

    private static char[] trim(char[] ca, int len) {
        if (len == ca.length) {
            return ca;
        }
        char[] tca = new char[len];
        System.arraycopy(ca, 0, tca, 0, len);
        return tca;
    }

    public char[] getBuffer() {
        if (JDK14) {
            return this.get14Buffer();
        }
        CharArrayWriter out = null;
        try {
            out = new CharArrayWriter();
            InputStreamReader reader = this.encoding != null ? new InputStreamReader((InputStream)new ByteArrayInputStream(this.buffer.toByteArray()), this.encoding) : new InputStreamReader(new ByteArrayInputStream(this.buffer.toByteArray()));
            int i = 0;
            while ((i = reader.read()) != -1) {
                out.write(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toCharArray();
    }

    public void flush() {
        try {
            this.target.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String val = "abcdefsdoihsdifhu saiudfg qqwe ";
        val = val + "\\u0126\\u0118\\u0139\\u0139\\u0150";
        StringBuffer sb = new StringBuffer(1000);
        for (int i = 0; i < 500; ++i) {
            sb.append(val);
        }
        bos.write(val.getBytes(DEFAULT_ENCODING));
        PageOutputStream os = new PageOutputStream(bos, DEFAULT_ENCODING);
        int iterations = 10000;
        long[] blah = new long[iterations];
        long now = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            char[] chars = os.getBuffer();
            blah[i] = chars.length;
        }
        System.out.println("time taken for buffer=" + (double)(System.currentTimeMillis() - now) / (double)iterations);
    }
}

