/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.module.sitemesh.filter.PageResponseWrapper;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class PageFilter
implements Filter,
RequestConstants {
    private FilterConfig filterConfig = null;
    private Factory factory = null;
    private boolean useWriter = false;
    private boolean useStream = false;

    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        if (rq.getAttribute("__sitemesh__filterapplied") != null) {
            chain.doFilter(rq, rs);
        } else {
            Page page;
            HttpServletRequest request = (HttpServletRequest)rq;
            HttpServletResponse response = (HttpServletResponse)rs;
            request.setAttribute("__sitemesh__filterapplied", (Object)Boolean.TRUE);
            if (Container.get() == 1) {
                request.getSession(true);
            }
            if ((page = this.parsePage(request, response, chain)) != null) {
                page.setRequest(request);
                Decorator decorator = this.factory.getDecoratorMapper().getDecorator(request, page);
                if (decorator != null && decorator.getPage() != null) {
                    this.applyDecorator(page, decorator, request, response);
                    page = null;
                    return;
                }
                this.writeOriginal(response, page);
                page = null;
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.filterConfig = filterConfig;
            this.factory = Factory.getInstance(new Config(filterConfig));
        } else {
            this.destroy();
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public void destroy() {
        this.factory = null;
    }

    private Page parsePage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean debug = Boolean.valueOf(this.filterConfig.getInitParameter("debug.pagewriter"));
        try {
            PageResponseWrapper pageResponse = new PageResponseWrapper(response, new Config(this.filterConfig), debug);
            chain.doFilter((ServletRequest)request, (ServletResponse)pageResponse);
            Page result = (Page)request.getAttribute("__sitemesh__page");
            if (result == null) {
                result = pageResponse.getPage();
            }
            this.useStream = pageResponse.isUsingStream();
            this.useWriter = pageResponse.isUsingWriter();
            pageResponse.closeWriter();
            return result;
        }
        catch (IllegalStateException e) {
            if (Container.get() != 4) {
                throw e;
            }
            return null;
        }
    }

    private void applyDecorator(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            request.setAttribute("__sitemesh__page", (Object)page);
            ServletContext context = this.filterConfig.getServletContext();
            if (decorator.getURIPath() != null && context.getContext(decorator.getURIPath()) != null) {
                context = context.getContext(decorator.getURIPath());
            }
            RequestDispatcher dispatcher = context.getRequestDispatcher(decorator.getPage());
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
            while (decorator.getInitParameterNames().hasNext()) {
                String initParam = (String)decorator.getInitParameterNames().next();
                if (!initParam.startsWith("header.")) continue;
                response.setHeader(initParam.substring(initParam.indexOf(46)), decorator.getInitParameter(initParam));
            }
            request.removeAttribute("__sitemesh__page");
        }
        catch (RuntimeException e) {
            if (Container.get() == 1) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private void writeOriginal(HttpServletResponse response, Page page) throws IOException {
        response.setContentLength(page.getContentLength());
        if (this.useStream) {
            PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
            page.writePage(writer);
            writer.flush();
            response.getOutputStream().flush();
        } else {
            page.writePage(response.getWriter());
            response.getWriter().flush();
        }
    }
}

