package com.qingcha.verifier.example;

import com.qingcha.verifier.spring.EnableVerifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

import java.util.Collections;

/**
 * @author qiqiang
 */
@SpringBootApplication
@EnableVerifier
public class ExampleApplication {
    public static void main(String[] args) {
        ConfigurableApplicationContext context = SpringApplication.run(ExampleApplication.class);
        StudentService studentService = context.getBean(StudentService.class);
        Student student = new Student();
        student.setGrade("六年级");
        student.setHobbies(Collections.singletonList("睡觉"));
        studentService.addStudent(student);
    }
}