/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.core.BaseConnection;
import org.apache.ojb.otm.core.ConcreteEditingContext;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.core.TransactionInProgressException;
import org.apache.ojb.otm.core.TransactionListener;
import org.apache.ojb.otm.core.TransactionNotInProgressException;

public class Transaction {
    private boolean _isInProgress;
    private List _listeners = new ArrayList();
    private List _connections = new ArrayList();
    private OTMKit _kit;

    public OTMKit getKit() {
        return this._kit;
    }

    public void setKit(OTMKit oTMKit) {
        this._kit = oTMKit;
    }

    public void begin() throws TransactionException {
        Object object;
        if (this._isInProgress) {
            throw new TransactionInProgressException("Transaction already in progress, cannot restart");
        }
        this._isInProgress = true;
        Iterator iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            object = (BaseConnection)iterator.next();
            ((BaseConnection)object).transactionBegin();
        }
        iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            object = (TransactionListener)iterator.next();
            object.transactionBegan(this);
        }
    }

    public void commit() throws TransactionException {
        Object object;
        if (!this._isInProgress) {
            throw new TransactionNotInProgressException("Transaction not in progress, nothing to commit");
        }
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            object = (TransactionListener)iterator.next();
            object.transactionCommitting(this);
        }
        iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            object = (BaseConnection)iterator.next();
            ConcreteEditingContext concreteEditingContext = (ConcreteEditingContext)((BaseConnection)object).getEditingContext();
            concreteEditingContext.commit();
            ((BaseConnection)object).transactionPrepare();
        }
        iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            object = (BaseConnection)iterator.next();
            ((BaseConnection)object).transactionCommit();
            ((BaseConnection)object).setTransaction(null);
        }
        this._connections.clear();
        this._isInProgress = false;
    }

    public void checkpoint() throws TransactionException {
        if (!this._isInProgress) {
            throw new TransactionNotInProgressException("Transaction not in progress, cannot checkpoint");
        }
        Iterator iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            BaseConnection baseConnection = (BaseConnection)iterator.next();
            ConcreteEditingContext concreteEditingContext = (ConcreteEditingContext)baseConnection.getEditingContext();
            concreteEditingContext.checkpoint();
        }
    }

    public void rollback() throws TransactionException {
        Object object;
        if (!this._isInProgress) {
            throw new TransactionNotInProgressException("Transaction not in progress, nothing to commit");
        }
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            object = (TransactionListener)iterator.next();
            object.transactionRollingBack(this);
        }
        iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            object = (BaseConnection)iterator.next();
            ConcreteEditingContext concreteEditingContext = (ConcreteEditingContext)((BaseConnection)object).getEditingContext();
            concreteEditingContext.rollback();
            ((BaseConnection)object).transactionRollback();
            ((BaseConnection)object).setTransaction(null);
        }
        this._connections.clear();
        this._isInProgress = false;
    }

    public boolean isInProgress() {
        return this._isInProgress;
    }

    public void registerConnection(OTMConnection oTMConnection) {
        Transaction transaction = oTMConnection.getTransaction();
        if (transaction != null && transaction != this) {
            throw new TransactionException("Attempt to re-assign a different transaction to a open connection");
        }
        if (!this._connections.contains(oTMConnection)) {
            this._connections.add(oTMConnection);
            oTMConnection.setTransaction(this);
        }
    }

    public void registerListener(TransactionListener transactionListener) {
        if (this._listeners.indexOf(transactionListener) < 0) {
            this._listeners.add(transactionListener);
        }
    }
}

