/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.core.proxy.SetProxyDefaultImpl;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.otm.EditingContext;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.core.LockingPassthruException;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionAbortedException;
import org.apache.ojb.otm.lock.LockManager;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.states.State;
import org.apache.ojb.otm.swizzle.Swizzling;

public class ConcreteEditingContext
implements EditingContext,
MaterializationListener,
ObjectCache {
    private static HashMap _withBidirAsscMap = new HashMap();
    private static HashMap _withoutBidirAsscMap = new HashMap();
    private HashSet _withBidirAssc;
    private HashSet _withoutBidirAssc;
    private HashMap _objects;
    private ArrayList _order;
    private Transaction _tx;
    private PersistenceBroker _pb;
    private HashMap _original;
    private HashMap _checkpointed;
    private HashMap _colProxyListeners;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public ConcreteEditingContext(Transaction transaction, PersistenceBroker persistenceBroker) {
        this._tx = transaction;
        this._pb = persistenceBroker;
        this._objects = new HashMap();
        this._order = new ArrayList();
        this._original = new HashMap();
        this._checkpointed = this._original;
        PBKey pBKey = this._pb.getPBKey();
        this._withoutBidirAssc = (HashSet)_withoutBidirAsscMap.get(pBKey);
        if (this._withoutBidirAssc != null) {
            this._withBidirAssc = (HashSet)_withBidirAsscMap.get(pBKey);
        } else {
            this._withoutBidirAssc = new HashSet();
            _withoutBidirAsscMap.put(pBKey, this._withoutBidirAssc);
            this._withBidirAssc = new HashSet();
            _withBidirAsscMap.put(pBKey, this._withBidirAssc);
        }
    }

    public void insert(Identity identity, Object object, int n) throws LockingException {
        ContextEntry contextEntry = this.insertInternal(identity, object, n, true, null, new Stack());
        if (contextEntry != null && contextEntry.state.needsDelete()) {
            contextEntry.state = State.PERSISTENT_CLEAN;
        }
    }

    private ContextEntry insertInternal(Identity identity, Object object, int n, boolean bl, Identity identity2, Stack stack) throws LockingException {
        IndirectionHandler indirectionHandler = null;
        OTMKit oTMKit = this._tx.getKit();
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            return null;
        }
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        if (object == null) {
            this._original.remove(identity);
            this._checkpointed.remove(identity);
            if (contextEntry != null) {
                contextEntry.userObject = null;
                contextEntry.cacheObject = null;
            }
            return contextEntry;
        }
        LockManager lockManager = LockManager.getInstance();
        Swizzling swizzling = oTMKit.getSwizzlingStrategy();
        indirectionHandler = ProxyHelper.getIndirectionHandler(object);
        if (indirectionHandler != null && indirectionHandler.alreadyMaterialized()) {
            object = indirectionHandler.getRealSubject();
            indirectionHandler = null;
        }
        if (contextEntry == null || contextEntry.userObject == null) {
            Object object2;
            Object object3 = swizzling.swizzle(object, null, this._pb, this);
            contextEntry = new ContextEntry(object3);
            if (contextEntry.handler != null) {
                object2 = this._tx.getKit().getCopyStrategy(identity);
                contextEntry.cacheObject = object2.copy(object, this._pb);
                this._objects.put(identity, contextEntry);
                lockManager.ensureLock(identity, this._tx, n, this._pb);
                contextEntry.handler.addListener(this);
            } else {
                object2 = this._pb.getObjectByIdentity(identity);
                if (object2 == null && !bl) {
                    throw new IllegalStateException("Related object is neither persistent, nor otm-depentent: " + identity);
                }
                if (object2 != null) {
                    contextEntry.cacheObject = object2;
                }
                bl2 = true;
                this._objects.put(identity, contextEntry);
                lockManager.ensureLock(identity, this._tx, n, this._pb);
                if (object != null) {
                    if (object2 == null && bl) {
                        ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
                        contextEntry.cacheObject = objectCopyStrategy.copy(object, this._pb);
                        contextEntry.state = State.PERSISTENT_NEW;
                        if (oTMKit.isEagerInsert(object) || this.hasBidirectionalAssociation(object.getClass())) {
                            this._pb.store(contextEntry.cacheObject, contextEntry.state);
                            contextEntry.state = State.PERSISTENT_CLEAN;
                            object2 = contextEntry.cacheObject;
                        }
                    }
                    if (object2 != null) {
                        this._original.put(identity, this.getFields(object, false, true));
                    }
                }
            }
            if (identity2 != null) {
                int n2 = this._order.indexOf(identity2);
                this._order.add(n2, identity);
            } else {
                this._order.add(identity);
            }
        } else {
            lockManager.ensureLock(identity, this._tx, n, this._pb);
            if (indirectionHandler == null && !swizzling.isSameInstance(contextEntry.userObject, object)) {
                if (contextEntry.handler != null) {
                    contextEntry.userObject = contextEntry.handler.getRealSubject();
                    contextEntry.handler = null;
                }
                bl3 = true;
            }
        }
        if (indirectionHandler == null && !stack.contains(object)) {
            stack.push(object);
            this.lockReachableObjects(identity, object, contextEntry.cacheObject, n, stack, bl2);
            stack.pop();
            if (bl3) {
                contextEntry.userObject = swizzling.swizzle(object, contextEntry.userObject, this._pb, this);
            }
        }
        return contextEntry;
    }

    private void lockReachableObjects(Identity identity, Object object, Object object2, int n, Stack stack, boolean bl) throws LockingException {
        Identity identity2;
        ContextEntry contextEntry;
        PersistentField persistentField;
        Object object3;
        boolean bl2;
        boolean bl3 = !this._tx.getKit().isImplicitLockingUsed();
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor objectReferenceDescriptor = null;
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            bl2 = objectReferenceDescriptor.getOtmDependent();
            if (bl3 && !bl2 || (object3 = (persistentField = objectReferenceDescriptor.getPersistentField()).get(object)) == null || (contextEntry = (ContextEntry)this._objects.get(identity2 = new Identity(object3, this._pb))) != null && contextEntry.userObject == object3) continue;
            contextEntry = this.insertInternal(identity2, object3, n, bl2, identity, stack);
            if (!bl || contextEntry == null) continue;
            persistentField.set(object, contextEntry.userObject);
            persistentField.set(object2, contextEntry.cacheObject);
        }
        Iterator iterator2 = classDescriptor.getCollectionDescriptors().iterator();
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        while (iterator2.hasNext()) {
            ArrayIterator arrayIterator;
            Object object4;
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator2.next();
            persistentField = collectionDescriptor.getPersistentField();
            Class clazz = persistentField.getType();
            bl2 = collectionDescriptor.getOtmDependent();
            if (bl3 && !bl2 || (object4 = persistentField.get(object)) == null || object4 instanceof CollectionProxyDefaultImpl && !((CollectionProxyDefaultImpl)object4).isLoaded()) continue;
            if (bl) {
                arrayList = new ArrayList<Object>();
                arrayList2 = new ArrayList<Object>();
            }
            if ((class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(clazz)) {
                arrayIterator = ((Collection)object4).iterator();
            } else if (clazz.isArray()) {
                arrayIterator = new ArrayIterator(object4);
            } else {
                throw new OJBRuntimeException(object4.getClass() + " can not be managed by OJB OTM, use Array or Collection instead !");
            }
            while (arrayIterator.hasNext()) {
                object3 = arrayIterator.next();
                identity2 = new Identity(object3, this._pb);
                contextEntry = (ContextEntry)this._objects.get(identity2);
                if (contextEntry == null || contextEntry.userObject != object3) {
                    contextEntry = this.insertInternal(identity2, object3, n, bl2, null, stack);
                }
                if (!bl || contextEntry == null) continue;
                arrayList.add(contextEntry.userObject);
                arrayList2.add(contextEntry.cacheObject);
            }
            if (!bl) continue;
            this.setCollectionField(object, persistentField, arrayList);
            this.setCollectionField(object2, persistentField, arrayList2);
        }
    }

    public void remove(Identity identity) {
        this._objects.remove(identity);
        this._order.remove(identity);
        LockManager.getInstance().releaseLock(identity, this._tx);
    }

    public void deletePersistent(Identity identity, Object object) throws LockingException {
        ContextEntry contextEntry = this.insertInternal(identity, object, 2, true, null, new Stack());
        if (contextEntry != null) {
            contextEntry.state = contextEntry.state.deletePersistent();
        }
        this._order.remove(identity);
        this._order.add(identity);
    }

    public Object lookup(Identity identity) {
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        return contextEntry == null ? null : contextEntry.userObject;
    }

    public boolean contains(Identity identity) {
        return this.lookup(identity) != null;
    }

    public State lookupState(Identity identity) throws LockingException {
        State state = null;
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        if (contextEntry != null) {
            state = contextEntry.state;
        }
        return state;
    }

    public void setState(Identity identity, State state) {
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        contextEntry.state = state;
    }

    public Collection getAllObjectsInContext() {
        return this._objects.values();
    }

    public void beforeMaterialization(IndirectionHandler indirectionHandler, Identity identity) {
    }

    public void afterMaterialization(IndirectionHandler indirectionHandler, Object object) {
        Identity identity = indirectionHandler.getIdentity();
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        if (contextEntry == null) {
            return;
        }
        int n = LockManager.getInstance().getLockHeld(identity, this._tx);
        ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
        Object object2 = objectCopyStrategy.copy(object, this._pb);
        indirectionHandler.setRealSubject(object2);
        this._original.put(identity, this.getFields(object2, false, true));
        contextEntry.userObject = object2;
        contextEntry.cacheObject = object;
        contextEntry.handler.removeListener(this);
        contextEntry.handler = null;
        try {
            this.lockReachableObjects(identity, object2, object, n, new Stack(), true);
        }
        catch (LockingException lockingException) {
            throw new LockingPassthruException(lockingException);
        }
    }

    public void commit() throws TransactionAbortedException {
        this.checkpointInternal(true);
        this.releaseLocksAndClear();
    }

    private void releaseLocksAndClear() {
        this.releaseLocks();
        this.removeMaterializationListener();
        this._objects.clear();
        this._order.clear();
        this._original.clear();
        if (this._checkpointed != this._original) {
            this._checkpointed.clear();
        }
    }

    public void checkpoint() throws TransactionAbortedException {
        this.checkpointInternal(false);
        this._checkpointed = new HashMap();
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
            if (contextEntry.handler != null) continue;
            this._checkpointed.put(identity, this.getFields(contextEntry.userObject, false, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointInternal(boolean bl) throws TransactionAbortedException {
        if (this._order.size() == 0) {
            return;
        }
        this.removeCollectionProxyListeners();
        ConnectionManagerIF connectionManagerIF = this._pb.serviceConnectionManager();
        boolean bl2 = connectionManagerIF.isBatchMode();
        Swizzling swizzling = this._tx.getKit().getSwizzlingStrategy();
        LockManager lockManager = LockManager.getInstance();
        Identity[] identityArray = this._order.toArray(new Identity[this._order.size()]);
        ObjectCache objectCache = this._pb.serviceObjectCache();
        boolean bl3 = this._tx.getKit().isInsertVerified();
        ArrayList arrayList = new ArrayList();
        Arrays.sort(identityArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.hashCode() - object2.hashCode();
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        try {
            int n;
            Object object;
            Object object2;
            Object object3;
            Iterator iterator;
            int n2;
            ArrayList arrayList2 = new ArrayList();
            do {
                arrayList2.clear();
                n2 = 0;
                for (int i = 0; i < identityArray.length; ++i) {
                    iterator = identityArray[i];
                    object3 = (ContextEntry)this._objects.get(iterator);
                    object2 = ((ContextEntry)object3).state;
                    if (((ContextEntry)object3).userObject == null || ((ContextEntry)object3).handler != null || ((State)object2).isDeleted()) continue;
                    object = (Object[][])this._checkpointed.get(iterator);
                    Object[][] objectArray = this.getFields(((ContextEntry)object3).userObject, true, !bl);
                    if (object == null) {
                        ((ContextEntry)object3).needsCacheSwizzle = true;
                        arrayList2.addAll(this.handleDependentReferences((Identity)((Object)iterator), ((ContextEntry)object3).userObject, null, objectArray[0], objectArray[2]));
                        arrayList2.addAll(this.handleDependentCollections((Identity)((Object)iterator), ((ContextEntry)object3).userObject, null, objectArray[1], objectArray[3]));
                        continue;
                    }
                    if (this.isModified(object[0], objectArray[0])) {
                        ((ContextEntry)object3).state = ((State)object2).markDirty();
                        ((ContextEntry)object3).needsCacheSwizzle = true;
                        lockManager.ensureLock((Identity)((Object)iterator), this._tx, 2, this._pb);
                        arrayList2.addAll(this.handleDependentReferences((Identity)((Object)iterator), ((ContextEntry)object3).userObject, (Object[])object[0], objectArray[0], objectArray[2]));
                    }
                    if (!this.isModified(object[1], objectArray[1])) continue;
                    ((ContextEntry)object3).needsCacheSwizzle = true;
                    lockManager.ensureLock((Identity)((Object)iterator), this._tx, 2, this._pb);
                    arrayList2.addAll(this.handleDependentCollections((Identity)((Object)iterator), ((ContextEntry)object3).userObject, (Object[])object[1], objectArray[1], objectArray[3]));
                    arrayList.add(iterator);
                }
                n2 = arrayList2.size();
                if (n2 <= 0) continue;
                identityArray = arrayList2.toArray(new Identity[n2]);
            } while (n2 > 0);
            Iterator iterator2 = this._order.iterator();
            while (iterator2.hasNext()) {
                iterator = (Identity)iterator2.next();
                object3 = (ContextEntry)this._objects.get(iterator);
                if (!((ContextEntry)object3).needsCacheSwizzle) continue;
                ((ContextEntry)object3).userObject = swizzling.getRealTarget(((ContextEntry)object3).userObject);
                ((ContextEntry)object3).cacheObject = swizzling.swizzle(((ContextEntry)object3).userObject, ((ContextEntry)object3).cacheObject, this._pb, new ObjectCache(){

                    public Object lookup(Identity identity) {
                        ContextEntry contextEntry = (ContextEntry)ConcreteEditingContext.this._objects.get(identity);
                        return contextEntry == null ? null : contextEntry.cacheObject;
                    }

                    public boolean contains(Identity identity) {
                        return this.lookup(identity) != null;
                    }

                    public void cache(Identity identity, Object object) {
                    }

                    public boolean cacheIfNew(Identity identity, Object object) {
                        return false;
                    }

                    public void clear() {
                    }

                    public void remove(Identity identity) {
                    }
                });
            }
            do {
                n = 0;
                iterator = new ArrayList(this._order).iterator();
                while (iterator.hasNext()) {
                    object3 = (Identity)iterator.next();
                    object2 = (ContextEntry)this._objects.get(object3);
                    if (!((ContextEntry)object2).state.isDeleted()) continue;
                    n += this.doCascadeDelete((Identity)object3, ((ContextEntry)object2).userObject);
                }
            } while (n > 0);
            connectionManagerIF.setBatchMode(true);
            try {
                iterator = this._order.iterator();
                while (iterator.hasNext()) {
                    object3 = (Identity)iterator.next();
                    object2 = (ContextEntry)this._objects.get(object3);
                    object = ((ContextEntry)object2).state;
                    if (!(((State)object).needsInsert() || ((State)object).needsUpdate() || ((State)object).needsDelete())) {
                        if (!arrayList.contains(object3)) continue;
                        this._pb.store(((ContextEntry)object2).cacheObject, (ObjectModification)object);
                        continue;
                    }
                    if (((State)object).needsInsert()) {
                        if (bl3) {
                            this._pb.store(((ContextEntry)object2).cacheObject);
                        } else if (objectCache.lookup((Identity)object3) == null) {
                            this._pb.store(((ContextEntry)object2).cacheObject, (ObjectModification)object);
                        }
                    } else if (((State)object).needsUpdate()) {
                        this._pb.store(((ContextEntry)object2).cacheObject, (ObjectModification)object);
                    } else if (((State)object).needsDelete()) {
                        this._pb.delete(((ContextEntry)object2).cacheObject);
                    }
                    ((ContextEntry)object2).state = ((State)object).commit();
                }
                connectionManagerIF.executeBatch();
            }
            finally {
                connectionManagerIF.setBatchMode(bl2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new TransactionAbortedException(throwable);
        }
    }

    public void rollback() {
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
            contextEntry.state = contextEntry.state.rollback();
            Object[][] objectArray = (Object[][])this._original.get(identity);
            if (objectArray == null) continue;
            this.setFields(contextEntry.userObject, objectArray);
            this.setFields(contextEntry.cacheObject, objectArray);
        }
        this.releaseLocksAndClear();
    }

    public void refresh(Identity identity, Object object) {
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        Object[][] objectArray = (Object[][])this._original.get(identity);
        if (objectArray != null) {
            this.setFields(contextEntry.userObject, objectArray);
            if (object != contextEntry.userObject) {
                this.setFields(object, objectArray);
            }
        }
        contextEntry.state = contextEntry.state.refresh();
    }

    private void removeMaterializationListener() {
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
            if (contextEntry.handler == null) continue;
            contextEntry.handler.removeListener(this);
        }
    }

    private void removeCollectionProxyListeners() {
        if (this._colProxyListeners != null) {
            Iterator iterator = this._colProxyListeners.keySet().iterator();
            while (iterator.hasNext()) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)iterator.next();
                CollectionProxyDefaultImpl collectionProxyDefaultImpl = (CollectionProxyDefaultImpl)this._colProxyListeners.get(collectionProxyListener);
                collectionProxyDefaultImpl.removeListener(collectionProxyListener);
            }
            this._colProxyListeners.clear();
        }
    }

    private void releaseLocks() {
        LockManager lockManager = LockManager.getInstance();
        Iterator iterator = this._objects.keySet().iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            lockManager.releaseLock(identity, this._tx);
        }
        this._tx.getKit().getLockMap().gc();
    }

    private boolean isEqual(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
            return ((BigDecimal)object).compareTo((BigDecimal)object2) == 0;
        }
        if (object instanceof Date && object2 instanceof Date) {
            return ((Date)object).getTime() == ((Date)object2).getTime();
        }
        return object.equals(object2);
    }

    private boolean isModified(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.isEqual(objectArray[i], objectArray2[i])) continue;
            return true;
        }
        return false;
    }

    private Object[][] getFields(Object object, boolean bl, boolean bl2) {
        Object object2;
        PersistentField persistentField;
        Serializable serializable;
        Iterator iterator;
        int n;
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        Vector vector2 = classDescriptor.getCollectionDescriptors();
        int n2 = 0;
        Object[] objectArray = new Object[1 + fieldDescriptorArray.length + vector.size()];
        ArrayList[] arrayListArray = new ArrayList[vector2.size()];
        Object[] objectArray2 = null;
        ArrayList[] arrayListArray2 = null;
        int n3 = 0;
        if (bl) {
            objectArray2 = new Object[vector.size()];
            arrayListArray2 = new ArrayList[vector2.size()];
        }
        if (bl2) {
            n3 = LockManager.getInstance().getLockHeld(new Identity(object, this._pb), this._tx);
        }
        objectArray[0] = object.getClass();
        ++n2;
        for (n = 0; n < fieldDescriptorArray.length; ++n) {
            iterator = fieldDescriptorArray[n];
            serializable = ((AttributeDescriptorBase)((Object)iterator)).getPersistentField();
            objectArray[n2] = serializable.get(object);
            ++n2;
        }
        n = 0;
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            serializable = (ObjectReferenceDescriptor)iterator.next();
            persistentField = ((AttributeDescriptorBase)serializable).getPersistentField();
            object2 = persistentField.get(object);
            if (object2 != null) {
                objectArray[n2] = new Identity(object2, this._pb);
                if (bl) {
                    objectArray2[n] = object2;
                }
            }
            ++n2;
            ++n;
        }
        n2 = 0;
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            block16: {
                ArrayIterator arrayIterator;
                ArrayList arrayList;
                Object object3;
                block18: {
                    Object object4;
                    block17: {
                        block15: {
                            serializable = (CollectionDescriptor)iterator.next();
                            persistentField = ((AttributeDescriptorBase)serializable).getPersistentField();
                            object2 = persistentField.getType();
                            object4 = persistentField.get(object);
                            if (object4 == null || !(object4 instanceof CollectionProxyDefaultImpl) || ((CollectionProxyDefaultImpl)object4).isLoaded()) break block15;
                            if (bl2) {
                                object3 = new OTMCollectionProxyListener((CollectionDescriptor)serializable, arrayListArray, n2, n3);
                                ((CollectionProxyDefaultImpl)object4).addListener((CollectionProxyListener)object3);
                                if (this._colProxyListeners == null) {
                                    this._colProxyListeners = new HashMap();
                                }
                                this._colProxyListeners.put(object3, object4);
                            }
                            break block16;
                        }
                        if (object4 == null) break block16;
                        object3 = new ArrayList();
                        arrayList = null;
                        arrayListArray[n2] = object3;
                        if (bl) {
                            arrayListArray2[n2] = arrayList = new ArrayList();
                        }
                        if (!(class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((Class<?>)object2)) break block17;
                        arrayIterator = ((Collection)object4).iterator();
                        break block18;
                    }
                    if (!((Class)object2).isArray()) break block16;
                    arrayIterator = new ArrayIterator(object4);
                }
                while (arrayIterator.hasNext()) {
                    Object e = arrayIterator.next();
                    ((ArrayList)object3).add(new Identity(e, this._pb));
                    if (!bl) continue;
                    arrayList.add(e);
                }
            }
            ++n2;
        }
        return new Object[][]{objectArray, arrayListArray, objectArray2, arrayListArray2};
    }

    private void setFields(Object object, Object[][] objectArray) {
        ArrayList<Object> arrayList;
        Serializable serializable;
        PersistentField persistentField;
        AttributeDescriptorBase attributeDescriptorBase;
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        Vector vector2 = classDescriptor.getCollectionDescriptors();
        Object[] objectArray2 = objectArray[0];
        ArrayList[] arrayListArray = (ArrayList[])objectArray[1];
        int n = 0;
        if (!objectArray2[0].equals(object.getClass())) {
            System.err.println("Can't restore the object fields since its class changed during transaction from " + objectArray2[0] + " to " + object.getClass());
            return;
        }
        ++n;
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            attributeDescriptorBase = fieldDescriptorArray[i];
            persistentField = attributeDescriptorBase.getPersistentField();
            persistentField.set(object, objectArray2[n]);
            ++n;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            attributeDescriptorBase = (ObjectReferenceDescriptor)iterator.next();
            persistentField = attributeDescriptorBase.getPersistentField();
            serializable = (Identity)objectArray2[n];
            arrayList = serializable == null ? null : this._pb.getObjectByIdentity((Identity)serializable);
            persistentField.set(object, arrayList);
            ++n;
        }
        n = 0;
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            attributeDescriptorBase = (CollectionDescriptor)iterator.next();
            persistentField = attributeDescriptorBase.getPersistentField();
            serializable = arrayListArray[n];
            if (serializable == null) {
                persistentField.set(object, null);
            } else {
                arrayList = new ArrayList<Object>();
                Iterator iterator2 = ((ArrayList)serializable).iterator();
                while (iterator2.hasNext()) {
                    Identity identity = (Identity)iterator2.next();
                    Object object2 = this._pb.getObjectByIdentity(identity);
                    if (object2 == null) continue;
                    arrayList.add(object2);
                }
                this.setCollectionField(object, persistentField, arrayList);
            }
            ++n;
        }
    }

    private void setCollectionField(Object object, PersistentField persistentField, List list) {
        Class clazz;
        if ((class$java$util$Collection == null ? (class$java$util$Collection = ConcreteEditingContext.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz = persistentField.getType())) {
            Collection collection = (ArrayList)persistentField.get(object);
            if (collection == null) {
                if (clazz == (class$java$util$List == null ? (class$java$util$List = ConcreteEditingContext.class$("java.util.List")) : class$java$util$List) || clazz == (class$java$util$Collection == null ? (class$java$util$Collection = ConcreteEditingContext.class$("java.util.Collection")) : class$java$util$Collection)) {
                    collection = new ArrayList();
                } else if (clazz == (class$java$util$Set == null ? (class$java$util$Set = ConcreteEditingContext.class$("java.util.Set")) : class$java$util$Set)) {
                    collection = new HashSet();
                } else {
                    try {
                        collection = (Collection)clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Cannot instantiate collection field: " + persistentField);
                        throwable.printStackTrace();
                        return;
                    }
                }
            } else if (collection instanceof CollectionProxyDefaultImpl) {
                CollectionProxyDefaultImpl collectionProxyDefaultImpl = (CollectionProxyDefaultImpl)collection;
                collection = collection instanceof List ? new ListProxyDefaultImpl(this._pb.getPBKey(), collectionProxyDefaultImpl.getData().getClass(), null) : (collection instanceof Set ? new SetProxyDefaultImpl(this._pb.getPBKey(), collectionProxyDefaultImpl.getData().getClass(), null) : new CollectionProxyDefaultImpl(this._pb.getPBKey(), collectionProxyDefaultImpl.getData().getClass(), null));
                collection.clear();
            } else {
                try {
                    collection = (Collection)collection.getClass().newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Cannot instantiate collection field: " + persistentField);
                    exception.printStackTrace();
                    return;
                }
            }
            collection.addAll(list);
            persistentField.set(object, collection);
        } else if (clazz.isArray()) {
            int n = list.size();
            Object object2 = Array.newInstance(clazz.getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                Array.set(object2, i, list.get(i));
            }
            persistentField.set(object, object2);
        }
    }

    private boolean hasBidirectionalAssociation(Class clazz) {
        if (this._withoutBidirAssc.contains(clazz)) {
            return false;
        }
        if (this._withBidirAssc.contains(clazz)) {
            return true;
        }
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(clazz);
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        boolean bl = false;
        Iterator iterator = vector.iterator();
        block0: while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            ClassDescriptor classDescriptor2 = this._pb.getClassDescriptor(objectReferenceDescriptor.getItemClass());
            Vector vector2 = classDescriptor2.getObjectReferenceDescriptors();
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                ObjectReferenceDescriptor objectReferenceDescriptor2 = (ObjectReferenceDescriptor)iterator2.next();
                if (!objectReferenceDescriptor2.getItemClass().equals(clazz)) continue;
                bl = true;
                break block0;
            }
        }
        if (bl) {
            this._withBidirAssc.add(clazz);
        } else {
            this._withoutBidirAssc.add(clazz);
        }
        return bl;
    }

    private int markDelete(Identity identity, Identity identity2, boolean bl) {
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        if (contextEntry == null) {
            throw new IllegalStateException("markDelete failed: the dependent object " + identity + " is not in the editing context");
        }
        if (contextEntry.state.isDeleted()) {
            return 0;
        }
        contextEntry.state = contextEntry.state.deletePersistent();
        if (identity2 != null) {
            int n = this._order.indexOf(identity);
            int n2 = this._order.indexOf(identity2);
            if (bl) {
                if (n > n2) {
                    this._order.remove(n);
                    this._order.add(n2, identity);
                }
            } else if (n < n2) {
                this._order.remove(n);
                this._order.add(n2, identity);
            }
        }
        return 1;
    }

    private ArrayList handleDependentReferences(Identity identity, Object object, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) throws LockingException {
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        int n = 1 + fieldDescriptorArray.length;
        ArrayList<Identity> arrayList = new ArrayList<Identity>();
        int n2 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Identity identity2 = objectArray == null ? null : (Identity)objectArray[n];
            Identity identity3 = (Identity)objectArray2[n];
            if (objectReferenceDescriptor.getOtmDependent()) {
                if (identity2 == null && identity3 != null) {
                    ContextEntry contextEntry = (ContextEntry)this._objects.get(identity3);
                    if (contextEntry == null) {
                        Object object2 = objectArray3[n2];
                        this.insertInternal(identity3, object2, 2, true, identity, new Stack());
                        arrayList.add(identity3);
                    }
                } else if (!(identity2 == null || identity3 != null && identity3.equals(identity2))) {
                    this.markDelete(identity2, identity, false);
                }
            }
            ++n;
            ++n2;
        }
        return arrayList;
    }

    private ArrayList handleDependentCollections(Identity identity, Object object, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) throws LockingException {
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        Vector vector = classDescriptor.getCollectionDescriptors();
        ArrayList<Identity> arrayList = new ArrayList<Identity>();
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            if (collectionDescriptor.getOtmDependent()) {
                Object object2;
                ArrayList arrayList2 = objectArray == null ? null : (ArrayList)objectArray[n];
                ArrayList arrayList3 = (ArrayList)objectArray2[n];
                if (arrayList2 != null) {
                    Iterator iterator2 = arrayList2.iterator();
                    while (iterator2.hasNext()) {
                        object2 = (Identity)iterator2.next();
                        if (arrayList3 != null && arrayList3.contains(object2)) continue;
                        this.markDelete((Identity)object2, identity, true);
                    }
                }
                if (arrayList3 != null) {
                    int n2 = 0;
                    object2 = arrayList3.iterator();
                    while (object2.hasNext()) {
                        ContextEntry contextEntry;
                        Identity identity2 = (Identity)object2.next();
                        if (!(arrayList2 != null && arrayList2.contains(identity2) || (contextEntry = (ContextEntry)this._objects.get(identity2)) != null)) {
                            ArrayList arrayList4 = (ArrayList)objectArray3[n];
                            Object e = arrayList4.get(n2);
                            this.insertInternal(identity2, e, 2, true, null, new Stack());
                            arrayList.add(identity2);
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return arrayList;
    }

    private int doCascadeDelete(Identity identity, Object object) {
        PersistentField persistentField;
        Object object2;
        ObjectReferenceDescriptor objectReferenceDescriptor;
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(ProxyHelper.getRealClass(object));
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        Vector vector2 = classDescriptor.getCollectionDescriptors();
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            if (!objectReferenceDescriptor.getOtmDependent() || (object2 = (persistentField = objectReferenceDescriptor.getPersistentField()).get(object)) == null) continue;
            n += this.markDelete(new Identity(object2, this._pb), identity, false);
        }
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            ArrayIterator arrayIterator;
            objectReferenceDescriptor = (CollectionDescriptor)iterator.next();
            if (!objectReferenceDescriptor.getOtmDependent()) continue;
            persistentField = objectReferenceDescriptor.getPersistentField();
            object2 = persistentField.getType();
            Object object3 = persistentField.get(object);
            if (object3 == null) continue;
            if ((class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((Class<?>)object2)) {
                arrayIterator = ((Collection)object3).iterator();
            } else {
                if (!((Class)object2).isArray()) continue;
                arrayIterator = new ArrayIterator(object3);
            }
            while (arrayIterator.hasNext()) {
                n += this.markDelete(new Identity(arrayIterator.next(), this._pb), identity, true);
            }
        }
        return n;
    }

    public void cache(Identity identity, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean cacheIfNew(Identity identity, Object object) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class OTMCollectionProxyListener
    implements CollectionProxyListener {
        private final CollectionDescriptor _cds;
        private final ArrayList[] _collections;
        private final int _index;
        private final int _lock;

        OTMCollectionProxyListener(CollectionDescriptor collectionDescriptor, ArrayList[] arrayListArray, int n, int n2) {
            this._cds = collectionDescriptor;
            this._collections = arrayListArray;
            this._index = n;
            this._lock = n2;
        }

        public void beforeLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
        }

        public void afterLoading(CollectionProxyDefaultImpl collectionProxyDefaultImpl) {
            ArrayList<Identity> arrayList = new ArrayList<Identity>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            LockManager lockManager = LockManager.getInstance();
            this._collections[this._index] = arrayList;
            Iterator iterator = collectionProxyDefaultImpl.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object e = iterator.next();
                Identity identity = new Identity(e, ConcreteEditingContext.this._pb);
                arrayList.add(identity);
                ContextEntry contextEntry = (ContextEntry)ConcreteEditingContext.this._objects.get(identity);
                if (contextEntry != null) {
                    object = contextEntry.userObject;
                } else {
                    ObjectCopyStrategy objectCopyStrategy = ConcreteEditingContext.this._tx.getKit().getCopyStrategy(identity);
                    object = objectCopyStrategy.copy(e, ConcreteEditingContext.this._pb);
                    try {
                        contextEntry = ConcreteEditingContext.this.insertInternal(identity, object, this._lock, this._cds.getOtmDependent(), null, new Stack());
                        if (contextEntry != null) {
                            object = contextEntry.userObject;
                        }
                    }
                    catch (LockingException lockingException) {
                        throw new LockingPassthruException(lockingException);
                    }
                }
                arrayList2.add(object);
            }
            collectionProxyDefaultImpl.clear();
            collectionProxyDefaultImpl.addAll(arrayList2);
        }
    }

    private static class ContextEntry {
        Object userObject;
        Object cacheObject;
        State state = State.PERSISTENT_CLEAN;
        IndirectionHandler handler;
        boolean needsCacheSwizzle;

        ContextEntry(Object object) {
            this.userObject = object;
            if (this.userObject != null) {
                this.handler = ProxyHelper.getIndirectionHandler(this.userObject);
                if (this.handler != null && this.handler.alreadyMaterialized()) {
                    this.userObject = this.handler.getRealSubject();
                    this.handler = null;
                }
            }
        }
    }
}

