/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.odmg.TransactionImpl;

public final class RuntimeObject {
    private final Object obj;
    private Identity identity;
    private final TransactionImpl tx;
    private Boolean isNew;
    private ClassDescriptor cld;
    private IndirectionHandler handler;

    public RuntimeObject(Object object, TransactionImpl transactionImpl) {
        this.tx = transactionImpl;
        this.obj = object;
        this.initCld(transactionImpl);
        this.doIsNewObjectCheck(transactionImpl);
    }

    public RuntimeObject(Object object, TransactionImpl transactionImpl, boolean bl) {
        this.tx = transactionImpl;
        this.obj = object;
        this.isNew = bl ? Boolean.TRUE : Boolean.FALSE;
        this.initCld(transactionImpl);
    }

    public RuntimeObject(Object object, Identity identity, TransactionImpl transactionImpl, boolean bl) {
        this.tx = transactionImpl;
        this.obj = object;
        this.identity = identity;
        this.isNew = bl ? Boolean.TRUE : Boolean.FALSE;
        this.initCld(transactionImpl);
    }

    public RuntimeObject(Object object, Identity identity, ClassDescriptor classDescriptor, boolean bl, boolean bl2) {
        this.tx = null;
        this.obj = object;
        this.identity = identity;
        this.isNew = bl ? Boolean.TRUE : Boolean.FALSE;
        this.cld = classDescriptor;
        if (bl2) {
            this.handler = ProxyHelper.getIndirectionHandler(object);
        }
    }

    private void initCld(TransactionImpl transactionImpl) {
        IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(this.obj);
        if (indirectionHandler != null) {
            this.handler = indirectionHandler;
            this.isNew = Boolean.FALSE;
            this.identity = indirectionHandler.getIdentity();
            this.cld = indirectionHandler.alreadyMaterialized() ? transactionImpl.getBroker().getClassDescriptor(indirectionHandler.getRealSubject().getClass()) : transactionImpl.getBroker().getClassDescriptor(this.identity.getObjectsRealClass());
        } else {
            this.cld = transactionImpl.getBroker().getClassDescriptor(this.obj.getClass());
        }
    }

    void doIsNewObjectCheck(TransactionImpl transactionImpl) {
        boolean bl = transactionImpl.isTransient(this.cld, this.obj, null);
        this.isNew = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getObj() {
        return this.obj;
    }

    public Object getObjMaterialized() {
        return this.handler != null ? (this.handler.alreadyMaterialized() ? this.handler.getRealSubject() : null) : this.obj;
    }

    public Identity getIdentity() {
        if (this.identity == null) {
            this.identity = this.tx.getBroker().serviceIdentity().buildIdentity(this.obj);
        }
        return this.identity;
    }

    public ClassDescriptor getCld() {
        return this.cld;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isProxy() {
        return this.handler != null;
    }

    public IndirectionHandler getHandler() {
        return this.handler;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("identity", (Object)this.identity).append("isNew", (Object)this.isNew).append("isProxy", this.handler != null).append("handler", (Object)this.handler).append("tx", (Object)this.tx).toString();
    }
}

