/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdori.sql;

import com.sun.jdori.Connector;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.jdori.sql.OjbStoreFatalInternalException;
import org.apache.ojb.jdori.sql.OjbStorePMF;

class OjbStoreConnector
implements Connector {
    private boolean rollbackOnlyFlag = false;
    private final OjbStorePMF pmf;
    PersistenceBroker broker = null;
    private boolean connectionReadyForRelease = true;
    private Logger logger = LoggerFactory.getLogger("JDO");

    OjbStoreConnector(OjbStorePMF ojbStorePMF) {
        this.pmf = ojbStorePMF;
    }

    public void begin(boolean bl) {
        this.assertNotRollbackOnly();
        this.connectionReadyForRelease = false;
        this.logger.debug("OjbStoreConnector.begin: connectionReadyForRelease=" + this.connectionReadyForRelease);
        this.broker = PersistenceBrokerFactory.defaultPersistenceBroker();
        this.broker.beginTransaction();
    }

    public void beforeCompletion() {
        this.assertNotRollbackOnly();
    }

    public void flush() {
        this.assertNotRollbackOnly();
        this.logger.debug("OjbStoreConnector.flush: connectionReadyForRelease=" + this.connectionReadyForRelease);
    }

    public synchronized void commit() {
        this.assertNotRollbackOnly();
        try {
            this.logger.debug("OjbStoreConnector.commit");
            this.broker.commitTransaction();
            this.broker.close();
            this.broker = null;
        }
        catch (Exception exception) {
            throw new OjbStoreFatalInternalException(this.getClass(), "commit", exception);
        }
        finally {
            this.connectionReadyForRelease = true;
        }
    }

    public synchronized void rollback() {
        this.logger.debug("OjbStoreConnector.rollback");
        if (!this.rollbackOnlyFlag) {
            try {
                this.broker.abortTransaction();
                this.broker.close();
                this.broker = null;
            }
            catch (Exception exception) {
                throw new OjbStoreFatalInternalException(this.getClass(), "rollback", exception);
            }
            finally {
                this.connectionReadyForRelease = true;
            }
        }
    }

    public void setRollbackOnly() {
        this.rollbackOnlyFlag = true;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnlyFlag;
    }

    private void assertNotRollbackOnly() {
        if (this.rollbackOnlyFlag) {
            throw new JDODataStoreException("Rollback Only !");
        }
    }

    public PersistenceBroker getBroker() {
        if (this.broker == null) {
            throw new JDOUserException("No transaction in progress.");
        }
        return this.broker;
    }

    public void setBroker(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
    }
}

