/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.RsIterator;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.otm.OTMConnection;

public class ExtentImpl
implements Extent {
    private Class m_clazz;
    private OTMConnection m_conn;
    private PersistenceManager m_pm;
    private HashSet m_iterators = new HashSet();
    private Criteria m_criteria;

    public ExtentImpl(Class clazz, OTMConnection oTMConnection, PersistenceManager persistenceManager, boolean bl) {
        this.m_clazz = clazz;
        this.m_conn = oTMConnection;
        this.m_pm = persistenceManager;
        this.m_criteria = new Criteria();
    }

    Class ojbGetClass() {
        return this.m_clazz;
    }

    public Iterator iterator() {
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(this.m_clazz, this.m_criteria);
        ExtentIterator extentIterator = new ExtentIterator((OJBIterator)this.m_conn.getIteratorByQuery(queryByCriteria));
        this.m_iterators.add(extentIterator);
        return extentIterator;
    }

    public boolean hasSubclasses() {
        ClassDescriptor classDescriptor = this.m_conn.getDescriptorFor(this.m_clazz);
        return classDescriptor.isExtent();
    }

    public Class getCandidateClass() {
        return this.m_clazz;
    }

    public PersistenceManager getPersistenceManager() {
        return this.m_pm;
    }

    public void closeAll() {
        Iterator iterator = this.m_iterators.iterator();
        while (iterator.hasNext()) {
            ExtentIterator extentIterator = (ExtentIterator)iterator.next();
            extentIterator.close();
            iterator.remove();
        }
    }

    public void close(Iterator iterator) {
        if (iterator instanceof ExtentIterator && this.m_iterators.contains(iterator)) {
            this.m_iterators.remove(iterator);
            ((ExtentIterator)iterator).close();
        }
    }

    private class ExtentIterator
    implements Iterator {
        private OJBIterator itty;
        private boolean closed = false;

        ExtentIterator(OJBIterator oJBIterator) {
            this.itty = oJBIterator;
        }

        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            return this.itty.hasNext();
        }

        public Object next() {
            if (this.closed) {
                throw new NoSuchElementException("Calling next() on closed JDO iterator");
            }
            try {
                return this.itty.next();
            }
            catch (RsIterator.ResourceClosedException resourceClosedException) {
                throw new NoSuchElementException("Calling next() on closed JDO iterator");
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Operation Not Allowd");
        }

        private void close() {
            this.itty.releaseDbResources();
            this.closed = true;
        }
    }
}

