/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerNativeImpl
extends AbstractSequenceManager {
    private Log log = LogFactory.getLog((Class)(class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl = SequenceManagerNativeImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerNativeImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl));
    private static volatile long tempKey = -1L;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl;

    public SequenceManagerNativeImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
    }

    public void afterStore(JdbcAccess jdbcAccess, ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
        FieldDescriptor fieldDescriptor = this.extractIdentityColumnField(classDescriptor);
        if (fieldDescriptor != null) {
            this.ifNotReadOnlyFail(fieldDescriptor);
            long l = this.getLastInsert(classDescriptor, fieldDescriptor);
            this.setFieldValue(object, fieldDescriptor, new Long(l));
        }
    }

    private FieldDescriptor extractIdentityColumnField(ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            if (!fieldDescriptorArray[i].isAutoIncrement() || !fieldDescriptorArray[i].isAccessReadOnly()) continue;
            return fieldDescriptorArray[i];
        }
        return null;
    }

    private void ifNotReadOnlyFail(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        if (!fieldDescriptor.isAccessReadOnly()) {
            throw new SequenceManagerException("Can't find Identity column: Identity columns/fields need to be declared as 'autoincrement' with 'readonly' access in field-descriptor");
        }
    }

    /*
     * Loose catch block
     */
    private long getLastInsert(ClassDescriptor classDescriptor, FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        long l;
        block13: {
            l = 0L;
            Statement statement = null;
            if (fieldDescriptor != null) {
                block12: {
                    statement = this.getBrokerForClass().serviceConnectionManager().getConnection().createStatement();
                    ResultSet resultSet = statement.executeQuery(this.lastInsertSelect(classDescriptor.getFullTableName()));
                    if (!resultSet.next()) {
                        throw new SequenceManagerException("Could not find native identifier");
                    }
                    l = resultSet.getLong(1);
                    resultSet.close();
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug((Object)("After store - newid=" + l));
                }
                Object var8_7 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    break block13;
                }
                catch (SQLException sQLException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Threw SQLException while in getLastInsert and closing stmt", (Throwable)sQLException);
                    }
                    break block13;
                }
                {
                    catch (Exception exception) {
                        throw new SequenceManagerException(exception);
                    }
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var8_8 = null;
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!this.log.isDebugEnabled()) break block14;
                            this.log.debug((Object)"Threw SQLException while in getLastInsert and closing stmt", (Throwable)sQLException);
                        }
                    }
                    throw throwable;
                }
            }
            throw new SequenceManagerException("No autoincrement field declared, please check repository for " + classDescriptor);
        }
        return l;
    }

    protected String lastInsertSelect(String string) {
        return this.getBrokerForClass().serviceConnectionManager().getSupportedPlatform().getLastInsertIdentityQuery(string);
    }

    private void setFieldValue(Object object, FieldDescriptor fieldDescriptor, Long l) throws SequenceManagerException {
        Object object2 = fieldDescriptor.getJdbcType().sequenceKeyConversion(l);
        object2 = fieldDescriptor.getFieldConversion().sqlToJava(object2);
        PersistentField persistentField = fieldDescriptor.getPersistentField();
        persistentField.set(object, object2);
    }

    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        return --tempKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

