/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.io.PrintWriter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.util.logging.Logger;

public class LoggerWrapperPrintWriter
extends PrintWriter {
    private static final String LINESEP = System.getProperty("line.separator");
    private static final int DEFAULT_LEVEL = 2;
    private final Logger logger;
    private final int level;
    private final boolean filterEverything;

    public LoggerWrapperPrintWriter(Logger logger, int n) {
        super(System.out);
        this.logger = logger;
        this.level = n;
        this.filterEverything = !logger.isEnabledFor(n);
    }

    public LoggerWrapperPrintWriter(Logger logger) {
        this(logger, 2);
    }

    private void log(String string) {
        switch (this.level) {
            case 5: {
                this.logger.fatal(string);
                break;
            }
            case 4: {
                this.logger.error(string);
                break;
            }
            case 3: {
                this.logger.warn(string);
                break;
            }
            case 2: {
                this.logger.info(string);
                break;
            }
            case 1: {
                this.logger.debug(string);
                break;
            }
            default: {
                throw new RuntimeException("Internal OJB fault. Logger API does not permit level " + this.level);
            }
        }
    }

    private void logLn(String string) {
        if (string != null) {
            this.log(string);
        }
        this.log(LINESEP);
    }

    public void println() {
        if (!this.filterEverything) {
            this.logLn(null);
        }
    }

    public void print(char c) {
        if (!this.filterEverything) {
            this.log(new String(new char[]{c}));
        }
    }

    public void println(char c) {
        if (!this.filterEverything) {
            this.logLn(new String(new char[]{c}));
        }
    }

    public void print(double d) {
        if (!this.filterEverything) {
            this.log(Double.toString(d));
        }
    }

    public void println(double d) {
        if (!this.filterEverything) {
            this.logLn(Double.toString(d));
        }
    }

    public void print(float f) {
        if (!this.filterEverything) {
            this.log(Float.toString(f));
        }
    }

    public void println(float f) {
        if (!this.filterEverything) {
            this.logLn(Float.toString(f));
        }
    }

    public void print(int n) {
        if (!this.filterEverything) {
            this.log(Integer.toString(n));
        }
    }

    public void println(int n) {
        if (!this.filterEverything) {
            this.logLn(Integer.toString(n));
        }
    }

    public void print(long l) {
        if (!this.filterEverything) {
            this.log(Long.toString(l));
        }
    }

    public void println(long l) {
        if (!this.filterEverything) {
            this.logLn(Long.toString(l));
        }
    }

    public void print(boolean bl) {
        if (!this.filterEverything) {
            this.log(BooleanUtils.toStringTrueFalse((boolean)bl));
        }
    }

    public void println(boolean bl) {
        if (!this.filterEverything) {
            this.logLn(BooleanUtils.toStringTrueFalse((boolean)bl));
        }
    }

    public void print(char[] cArray) {
        if (!this.filterEverything) {
            this.log(new String(cArray));
        }
    }

    public void println(char[] cArray) {
        if (!this.filterEverything) {
            this.logLn(new String(cArray));
        }
    }

    public void print(Object object) {
        if (!this.filterEverything && object != null) {
            this.log(object.toString());
        }
    }

    public void println(Object object) {
        if (!this.filterEverything && object != null) {
            this.logLn(object.toString());
        }
    }

    public void print(String string) {
        if (!this.filterEverything) {
            this.log(string);
        }
    }

    public void println(String string) {
        if (!this.filterEverything) {
            this.logLn(string);
        }
    }

    public void write(int n) {
        if (!this.filterEverything) {
            this.print(n);
        }
    }

    public void write(String string) {
        if (!this.filterEverything) {
            this.print(string);
        }
    }

    public void write(char[] cArray) {
        if (!this.filterEverything) {
            this.print(cArray);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (!this.filterEverything) {
            this.log(new String(cArray, n, n2));
        }
    }

    public void write(String string, int n, int n2) {
        if (!this.filterEverything) {
            this.log(string.substring(n, n2));
        }
    }
}

