/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class InterceptorFactory
implements Configurable {
    private static InterceptorFactory instance = null;
    private Class interceptorClassToBeUsed = null;
    static /* synthetic */ Class class$java$lang$Object;

    public static InterceptorFactory getInstance() {
        if (instance == null) {
            instance = new InterceptorFactory();
            OjbConfigurator.getInstance().configure(instance);
        }
        return instance;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Class clazz = configuration.getClass("InterceptorClass", class$java$lang$Object == null ? (class$java$lang$Object = InterceptorFactory.class$("java.lang.Object")) : class$java$lang$Object);
        if (!clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = InterceptorFactory.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.setInterceptorClassToBeUsed(clazz);
        }
    }

    public Object createInterceptorFor(Object object) {
        if (this.getInterceptorClassToBeUsed() != null) {
            try {
                InvocationHandler invocationHandler = (InvocationHandler)ClassHelper.newInstance(this.getInterceptorClassToBeUsed(), class$java$lang$Object == null ? (class$java$lang$Object = InterceptorFactory.class$("java.lang.Object")) : class$java$lang$Object, object);
                Class[] classArray = this.computeInterfaceArrayFor(object.getClass());
                Object object2 = Proxy.newProxyInstance(ClassHelper.getClassLoader(), classArray, invocationHandler);
                return object2;
            }
            catch (Throwable throwable) {
                LoggerFactory.getDefaultLogger().error("can't use Interceptor " + this.getInterceptorClassToBeUsed().getName() + "for " + object.getClass().getName(), throwable);
                return object;
            }
        }
        return object;
    }

    public Class[] computeInterfaceArrayFor(Class clazz) {
        Object object;
        Class clazz2 = clazz;
        Class[] classArray = clazz.getInterfaces();
        if (clazz.isInterface()) {
            object = new Class[classArray.length + 1];
            object[0] = clazz;
            System.arraycopy(classArray, 0, object, 1, classArray.length);
            classArray = object;
        }
        while ((clazz2 = clazz2.getSuperclass()) != null) {
            object = clazz2.getInterfaces();
            Class[] classArray2 = new Class[classArray.length + ((Class[])object).length];
            System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
            System.arraycopy(object, 0, classArray2, classArray.length, ((Object)object).length);
            classArray = classArray2;
        }
        object = new HashMap();
        for (int i = 0; i < classArray.length; ++i) {
            ((HashMap)object).put(classArray[i].getName(), classArray[i]);
        }
        classArray = ((HashMap)object).values().toArray(new Class[((HashMap)object).size()]);
        return classArray;
    }

    public Class getInterceptorClassToBeUsed() {
        return this.interceptorClassToBeUsed;
    }

    public void setInterceptorClassToBeUsed(Class clazz) {
        this.interceptorClassToBeUsed = clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

