/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.KeyConstraintViolatedException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;
import org.apache.ojb.broker.util.logging.Logger;

public abstract class ExceptionHelper {
    public static PersistenceBrokerSQLException generateException(String string, SQLException sQLException, String string2, Logger logger) {
        return ExceptionHelper.generateException(string, sQLException, string2, null, null, logger, null);
    }

    public static PersistenceBrokerSQLException generateException(SQLException sQLException, String string, ClassDescriptor classDescriptor, Logger logger, Object object) {
        return ExceptionHelper.generateException(sQLException, string, classDescriptor, null, logger, object);
    }

    public static PersistenceBrokerSQLException generateException(SQLException sQLException, String string, ClassDescriptor classDescriptor, ValueContainer[] valueContainerArray, Logger logger, Object object) {
        return ExceptionHelper.generateException(null, sQLException, string, classDescriptor, valueContainerArray, logger, object);
    }

    public static PersistenceBrokerSQLException generateException(String string, SQLException sQLException, String string2, ClassDescriptor classDescriptor, ValueContainer[] valueContainerArray, Logger logger, Object object) {
        FieldDescriptor[] fieldDescriptorArray;
        Object object2;
        String string3 = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer(string3);
        string3 = string3 + "* ";
        if (sQLException instanceof BatchUpdateException) {
            object2 = (BatchUpdateException)sQLException;
            if (string != null) {
                stringBuffer.append("* ").append(string);
            } else {
                stringBuffer.append("* BatchUpdateException during execution of sql-statement:");
            }
            stringBuffer.append(string3).append("Batch update count is '").append(((BatchUpdateException)object2).getUpdateCounts()).append("'");
        } else if (sQLException instanceof SQLWarning) {
            if (string != null) {
                stringBuffer.append("* ").append(string);
            } else {
                stringBuffer.append("* SQLWarning during execution of sql-statement:");
            }
        } else if (string != null) {
            stringBuffer.append("* ").append(string);
        } else {
            stringBuffer.append("* SQLException during execution of sql-statement:");
        }
        if (string2 != null) {
            stringBuffer.append(string3).append("sql statement was '").append(string2).append("'");
        }
        object2 = null;
        if (sQLException != null) {
            stringBuffer.append(string3).append("Exception message is [").append(sQLException.getMessage()).append("]");
            stringBuffer.append(string3).append("Vendor error code [").append(sQLException.getErrorCode()).append("]");
            stringBuffer.append(string3).append("SQL state code [");
            object2 = sQLException.getSQLState();
            if ("23000".equalsIgnoreCase((String)object2)) {
                stringBuffer.append((String)object2).append("=INTEGRITY CONSTRAINT VIOLATION");
            } else if ("23001".equalsIgnoreCase((String)object2)) {
                stringBuffer.append((String)object2).append("=RESTRICT VIOLATION");
            } else if ("23502".equalsIgnoreCase((String)object2)) {
                stringBuffer.append((String)object2).append("=NOT NULL VIOLATION");
            } else if ("23503".equalsIgnoreCase((String)object2)) {
                stringBuffer.append((String)object2).append("=FOREIGN KEY VIOLATION");
            } else if ("23505".equalsIgnoreCase((String)object2)) {
                stringBuffer.append((String)object2).append("=UNIQUE VIOLATION");
            } else if ("23514".equalsIgnoreCase((String)object2)) {
                stringBuffer.append((String)object2).append("=CHECK VIOLATION");
            } else {
                stringBuffer.append((String)object2);
            }
            stringBuffer.append("]");
        }
        if (classDescriptor != null) {
            stringBuffer.append(string3).append("Target class is '").append(classDescriptor.getClassNameOfObject()).append("'");
            fieldDescriptorArray = classDescriptor.getPkFields();
            stringBuffer.append(string3).append("PK of the target object is [");
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                try {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(fieldDescriptorArray[i].getPersistentField().getName());
                    if (object == null) continue;
                    stringBuffer.append("=");
                    stringBuffer.append(fieldDescriptorArray[i].getPersistentField().get(object));
                    continue;
                }
                catch (Exception exception) {
                    stringBuffer.append(" PK field build FAILED! ");
                }
            }
            stringBuffer.append("]");
        }
        if (valueContainerArray != null) {
            stringBuffer.append(string3).append(valueContainerArray.length).append(" values performed in statement: ").append(string3);
            for (int i = 0; i < valueContainerArray.length; ++i) {
                ValueContainer valueContainer = valueContainerArray[i];
                stringBuffer.append("[");
                stringBuffer.append("jdbcType=").append(JdbcTypesHelper.getSqlTypeAsString(valueContainer.getJdbcType().getType()));
                stringBuffer.append(", value=").append(valueContainer.getValue());
                stringBuffer.append("]");
            }
        }
        if (object != null) {
            stringBuffer.append(string3).append("Source object: ");
            try {
                stringBuffer.append(object.toString());
            }
            catch (Exception exception) {
                stringBuffer.append(object.getClass());
            }
        }
        fieldDescriptorArray = stringBuffer.toString();
        if (sQLException != null) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)sQLException);
            if (throwable == null) {
                throwable = sQLException;
            }
            stringBuffer.append(string3).append("The root stack trace is --> ");
            String string4 = ExceptionUtils.getStackTrace((Throwable)throwable);
            stringBuffer.append(string3).append(string4);
        }
        stringBuffer.append(SystemUtils.LINE_SEPARATOR).append("**");
        if (logger != null) {
            logger.error(stringBuffer.toString());
        }
        if ("23000".equals(object2) || "23505".equals(object2)) {
            throw new KeyConstraintViolatedException((String)fieldDescriptorArray, sQLException);
        }
        throw new PersistenceBrokerSQLException((String)fieldDescriptorArray, sQLException);
    }
}

