/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.AbstractQueryImpl;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class QueryByCriteria
extends AbstractQueryImpl {
    private Criteria m_criteria;
    private boolean m_distinct = false;
    private Map m_pathClasses;
    private Criteria m_havingCriteria;
    private String m_objectProjectionAttribute;
    private List m_orderby = null;
    private List m_groupby = null;
    private List m_prefetchedRelationships = null;
    private Collection m_pathOuterJoins = null;
    public static final Criteria CRITERIA_SELECT_ALL = null;

    public QueryByCriteria(Class clazz, Criteria criteria, Criteria criteria2, boolean bl) {
        super(clazz);
        this.setCriteria(criteria);
        this.setHavingCriteria(criteria2);
        this.m_distinct = bl;
        this.m_pathClasses = new HashMap();
        this.m_groupby = new ArrayList();
        this.m_orderby = new ArrayList();
        this.m_prefetchedRelationships = new ArrayList();
        this.m_pathOuterJoins = new HashSet();
    }

    public QueryByCriteria(Class clazz, Criteria criteria, Criteria criteria2) {
        this(clazz, criteria, criteria2, false);
    }

    public QueryByCriteria(Class clazz, Criteria criteria) {
        this(clazz, criteria, false);
    }

    public QueryByCriteria(Class clazz, Criteria criteria, boolean bl) {
        this(clazz, criteria, null, bl);
    }

    public QueryByCriteria(Object object, boolean bl) {
        this(object.getClass(), QueryByCriteria.buildCriteria(object), bl);
    }

    public QueryByCriteria(Object object) {
        this(object.getClass(), QueryByCriteria.buildCriteria(object));
    }

    public QueryByCriteria(Class clazz) {
        this(clazz, CRITERIA_SELECT_ALL);
    }

    private static Criteria buildCriteria(Object object) {
        Criteria criteria = new Criteria();
        ClassDescriptor classDescriptor = MetadataManager.getInstance().getRepository().getDescriptorFor(object.getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            try {
                PersistentField persistentField = fieldDescriptorArray[i].getPersistentField();
                Object object2 = persistentField.get(object);
                if (object2 == null) continue;
                criteria.addEqualTo(persistentField.getName(), object2);
                continue;
            }
            catch (Throwable throwable) {
                LoggerFactory.getDefaultLogger().error(throwable);
            }
        }
        return criteria;
    }

    public void addPathClass(String string, Class clazz) {
        List list = (List)this.m_pathClasses.get(string);
        if (list == null) {
            this.setPathClass(string, clazz);
        } else {
            list.add(clazz);
        }
    }

    public void setPathClass(String string, Class clazz) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        arrayList.add(clazz);
        this.m_pathClasses.put(string, arrayList);
    }

    public List getClassesForPath(String string) {
        return (List)this.m_pathClasses.get(string);
    }

    public boolean isPathOuterJoin(String string) {
        return this.getOuterJoinPaths().contains(string);
    }

    public void setPathOuterJoin(String string) {
        this.getOuterJoinPaths().add(string);
    }

    public Criteria getCriteria() {
        return this.m_criteria;
    }

    public Criteria getHavingCriteria() {
        return this.m_havingCriteria;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("QueryByCriteria from ");
        stringBuffer.append(this.getSearchClass()).append(" ");
        if (this.getCriteria() != null && !this.getCriteria().isEmpty()) {
            stringBuffer.append(" where ").append(this.getCriteria());
        }
        return stringBuffer.toString();
    }

    public boolean isDistinct() {
        return this.m_distinct;
    }

    public void setDistinct(boolean bl) {
        this.m_distinct = bl;
    }

    public Map getPathClasses() {
        return this.m_pathClasses;
    }

    public void setCriteria(Criteria criteria) {
        this.m_criteria = criteria;
        if (this.m_criteria != null) {
            this.m_criteria.setQuery(this);
        }
    }

    public void setHavingCriteria(Criteria criteria) {
        this.m_havingCriteria = criteria;
        if (this.m_havingCriteria != null) {
            this.m_havingCriteria.setQuery(this);
        }
    }

    public void addGroupBy(String string) {
        if (string != null) {
            this.m_groupby.add(new FieldHelper(string, false));
        }
    }

    public void addGroupBy(FieldHelper fieldHelper) {
        if (fieldHelper != null) {
            this.m_groupby.add(fieldHelper);
        }
    }

    public void addGroupBy(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addGroupBy(stringArray[i]);
        }
    }

    public List getGroupBy() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_groupby);
        if (this.getCriteria() != null) {
            arrayList.addAll(this.getCriteria().getGroupby());
        }
        return arrayList;
    }

    public void addOrderBy(String string, boolean bl) {
        if (string != null) {
            this.m_orderby.add(new FieldHelper(string, bl));
        }
    }

    public void addOrderBy(String string) {
        this.addOrderBy(string, true);
    }

    public void addOrderBy(FieldHelper fieldHelper) {
        if (fieldHelper != null) {
            this.m_orderby.add(fieldHelper);
        }
    }

    public void addOrderByAscending(String string) {
        this.addOrderBy(string, true);
    }

    public void addOrderByDescending(String string) {
        this.addOrderBy(string, false);
    }

    public List getOrderBy() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_orderby);
        if (this.getCriteria() != null) {
            arrayList.addAll(this.getCriteria().getOrderby());
        }
        return arrayList;
    }

    public void addPrefetchedRelationship(String string) {
        this.m_prefetchedRelationships.add(string);
    }

    public List getPrefetchedRelationships() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_prefetchedRelationships);
        if (this.getCriteria() != null) {
            arrayList.addAll(this.getCriteria().getPrefetchedRelationships());
        }
        return arrayList;
    }

    public Collection getOuterJoinPaths() {
        return this.m_pathOuterJoins;
    }

    public String getObjectProjectionAttribute() {
        return this.m_objectProjectionAttribute;
    }

    public void setObjectProjectionAttribute(String string) {
        ClassDescriptor classDescriptor = MetadataManager.getInstance().getRepository().getDescriptorFor(this.m_baseClass);
        ArrayList arrayList = classDescriptor.getAttributeDescriptorsForPath(string);
        int n = arrayList.size();
        if (n > 0 && arrayList.get(n - 1) instanceof ObjectReferenceDescriptor) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)arrayList.get(n - 1);
            this.setObjectProjectionAttribute(string, objectReferenceDescriptor.getItemClass());
        }
    }

    public void setObjectProjectionAttribute(String string, Class clazz) {
        this.m_objectProjectionAttribute = string;
        this.m_searchClass = clazz;
    }
}

