/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class PlatformSapdbImpl
extends PlatformDefaultImpl {
    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        if ((n2 == -3 || n2 == -4) && object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            preparedStatement.setBytes(n, byArray);
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }

    public byte getJoinSyntaxType() {
        return 2;
    }

    public boolean useCountForResultsetSize() {
        return true;
    }

    public String createSequenceQuery(String string) {
        return "CREATE SEQUENCE " + string;
    }

    public String createSequenceQuery(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(this.createSequenceQuery(string));
        if (properties != null) {
            Boolean bl;
            Long l = SequenceManagerHelper.getSeqIncrementBy(properties);
            if (l != null) {
                stringBuffer.append(" INCREMENT BY ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqStart(properties)) != null) {
                stringBuffer.append(" START WITH ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMaxValue(properties)) != null) {
                stringBuffer.append(" MAXVALUE ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMinValue(properties)) != null) {
                stringBuffer.append(" MINVALUE ").append(l);
            }
            if ((bl = SequenceManagerHelper.getSeqCycleValue(properties)) != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(" CYCLE");
                } else {
                    stringBuffer.append(" NOCYCLE");
                }
            }
            if ((l = SequenceManagerHelper.getSeqCacheValue(properties)) != null) {
                stringBuffer.append(" CACHE ").append(l);
            }
            if ((bl = SequenceManagerHelper.getSeqOrderValue(properties)) != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(" ORDER");
                } else {
                    stringBuffer.append(" NOORDER");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String nextSequenceQuery(String string) {
        return "select " + string + ".nextval from dual";
    }

    public String dropSequenceQuery(String string) {
        return "drop sequence " + string;
    }

    public void addPagingSql(StringBuffer stringBuffer) {
        stringBuffer.append(" ROWNO <= ? ");
    }

    public int bindPagingParameters(PreparedStatement preparedStatement, int n, int n2, int n3) throws SQLException {
        preparedStatement.setInt(n, n3 - 1);
        return ++n;
    }

    public boolean supportsPaging() {
        return true;
    }
}

